% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_custom_portfol.R
\name{MeanVar_portfolio}
\alias{MeanVar_portfolio}
\title{A helper function for MeanVar_portfolio}
\usage{
MeanVar_portfolio(mean_vec, cov_mtrx, gamma)
}
\arguments{
\item{mean_vec}{mean vector of asset returns provided in the form of a vector or a list.}

\item{cov_mtrx}{the covariance matrix of asset returns. Could be a matrix or a data frame.}

\item{gamma}{a numeric variable. Coefficient of risk aversion.}
}
\value{
Mean-variance portfolio in the form of object of S3 class MeanVar_portfolio.
}
\description{
A user-friendly function making mean-variance portfolios for assets with customly
computed covariance matrix and mean returns.
The weights are computed in accordance with the formula
\deqn{\hat w_{MV} = \frac{S^{-1} 1}{1' S^{-1} 1} + \gamma^{-1} \hat Q \bar x \quad ,}
where \eqn{S^{-1}} is the inverse of the covariance matrix, \eqn{\bar x} is the mean
vector of asset returns, \eqn{\gamma} is the coefficient of risk aversion, and
\eqn{\hat Q} is given by
\deqn{\hat Q = S^{-1} - \frac{S^{-1} 1 1' S^{-1}}{1' S^{-1} 1} .}
The computation is made by \code{\link{new_MeanVar_portfolio}} and then the result
is validated by \code{\link{validate_MeanVar_portfolio}}.
}
\examples{
n<-3e2 # number of realizations
p<-.5*n # number of assets
gamma<-1

x <- matrix(data = rnorm(n*p), nrow = p, ncol = n)

# Simple MV portfolio
cov_mtrx <- Sigma_sample_estimator(x)
means <- rowMeans(x)

cust_port_simp <- MeanVar_portfolio(mean_vec=means, cov_mtrx=cov_mtrx, gamma=2)
str(cust_port_simp)
}
