package de.fhg.iais.kd.gridr.interfaces.acgt;

import java.io.File;
import java.io.FileReader;

import org.bitlab.api.datatype.DataTypeModule;
import org.bitlab.api.exception.AccessDeniedException;
import org.bitlab.api.service.Operation;
import org.bitlab.api.service.Parameter;
import org.bitlab.api.service.Service;
import org.bitlab.api.service.ServiceModule;
import org.bitlab.api.util.Filter;
import org.bitlab.api.util.FilterList;



public class AcgtRepoList {
	public static void main(String[] args){
		
		if(args.length==0 || !(new File(args[0]).exists())){
			System.out.println("cannot find config file\n");
			return;
		}
		try{
			DataTypeModule dtm =new DataTypeModule(new FileReader(args[0]));
			ServiceModule serviceModule = new ServiceModule(new FileReader(args[0]), dtm);
		
			//FilterList<org.bitlab.api.datatype.DataType> dtl = dtm.getDataTypesList();
		/*
			//System.out.println(dtl.size() + ": " + dtl);
			Filter<DataType> f = new Filter<DataType>(){
				public boolean test(DataType element) {
					try {
						return element.getName().contains("Annotated");
					} catch (AccessDeniedException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
						return false;
					}
				}
			};
			dtl.addFilter(f);
		//	System.out.println(dtl.size() + ": " + dtl);
			
			
			dtl.addFilter(new Filter<DataType>() {
				public boolean test(DataType element) {
					return element.getCreationTime().before(Timestamp.valueOf("2007-01-01 00:00:00")) &&
					element.getCreationTime().after(Timestamp.valueOf("2006-01-01 00:00:00"));
				}
			});
			System.out.println(dtl.size() + ": " + dtl);
			dtl.clearFilters();
			System.out.println(dtl.size() + ": " + dtl);
			dtl.addFilter(new Filter<DataType>() {
				public boolean test(DataType element) {
					return element.getCreationTime().before(Timestamp.valueOf("2007-01-01 00:00:00")) &&
					element.getCreationTime().after(Timestamp.valueOf("2006-01-01 00:00:00"));
				}
			});
			System.out.println(dtl.size() + ": " + dtl);*/
			for(Service s : serviceModule.getServiceList()){
	

				System.out.print(s.getId() + "\nInput:");
				
				for(Operation o : s.getOperations())
				{
					/*
				System.out.println(" Id:"+
				o.getId());
				System.out.println(" Name:"+
				o.getName());
				System.out.println(" Description: "+o.getDescription());
				*/
				FilterList<Parameter> lp = o.getParameters();
				lp.addFilter(new Filter<Parameter>(){ // Take inputs of operation
				public boolean test(Parameter element) {
				try {
					return element.isInput();
				} catch (AccessDeniedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
					return false;
				}
				}
				});
	//			System.out.println(" Input: ");
				for(Parameter p : lp)
				{
					System.out.print(" ["+ p.getType() + "] " + p.getName());
				}
				lp.clearFilters();
		/*		lp.addFilter(new Filter<Parameter>(){ // Take outputs of operation
				public boolean test(Parameter element) {
				return !element.isInput();
				}
				});
				System.out.println();
				System.out.println(" Output: ");
				for(Parameter p : lp)
				showParameter(p);
*/				}
				System.out.println();
			}
		}
		catch(Exception e){
			System.out.println("Error, cannot connect to ACGT Repository\n"+ e.getMessage() + "\n");
			//e.printStackTrace();
		}
	}
}
