% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greedy_search.R
\name{initGreedyExperimentalDesignObject}
\alias{initGreedyExperimentalDesignObject}
\title{This method creates an object of type greedy_experimental_design and will immediately initiate
a search through $1_{T}$ space.}
\usage{
initGreedyExperimentalDesignObject(X, max_designs = 10000,
  objective = "abs_sum_diff", wait = FALSE, start = TRUE,
  max_iters = Inf, semigreedy = FALSE, diagnostics = FALSE,
  num_cores = 1)
}
\arguments{
\item{X}{The design matrix with $n$ rows (one for each subject) and $p$ columns 
(one for each measurement on the subject). This is the design matrix you wish 
to search for a more optimal design.}

\item{max_designs}{The maximum number of designs to be returned. Default is 10,000. Make this large 
so you can search however long you wish as the search can be stopped at any time by
using the \code{\link{stopSearch}} method}

\item{objective}{The objective function to use when greedily searching design space. This is a string
"\code{abs_sum_diff}" (default) or "\code{mahal_dist}."}

\item{wait}{Should the \code{R} terminal hang until all \code{max_designs} vectors are found? The 
deafult is \code{FALSE}.}

\item{start}{Should we start searching immediately (default is \code{TRUE}).}

\item{max_iters}{Should we impose a maximum number of greedy switches? The default is \code{Inf} which a flag 
for ``no limit.''}

\item{semigreedy}{Should we use a fully greedy approach or the quicker semi-greedy approach? The default is
\code{FALSE} corresponding to the fully greedy approach.}

\item{diagnostics}{Returns diagnostic information about the iterations including (a) the initial starting
vectors, the switches at every iteration and information about the objective function
at every iteration (default is \code{FALSE} due to speed concerns).}

\item{num_cores}{The number of CPU cores you wish to use during the search. The default is \code{1}.}
}
\value{
An object of type \code{greedy_experimental_design_search} which can be further operated upon
}
\description{
This method creates an object of type greedy_experimental_design and will immediately initiate
a search through $1_{T}$ space.
}
\examples{
 \dontrun{
	library(MASS)
	data(Boston)
 #pretend the Boston data was an experiment setting 
	#first pull out the covariates
 X = Boston[, 1 : 13] 
 #begin the greedy design search
	ged = initGreedyExperimentalDesignObject(X, 
		max_designs = 1000, num_cores = 3, objective = "abs_sum_diff")
	#wait
	ged
	}
}
\author{
Adam Kapelner
}
