% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landfClass.R
\name{landfClass}
\alias{landfClass}
\title{R function for landform classification on the basis od Topographic Position Index}
\usage{
landfClass(x, scale = 3, sn = 3, ln = 7, n.classes = "six",
  add.tpi = FALSE, stand.tpi = FALSE)
}
\arguments{
\item{x}{Input DTM (RasterLayer class).}

\item{scale}{Size (in terms of cells per side) of the neighborhood (moving window) to be used;
it must be an odd integer.}

\item{sn}{If the 10-class classification is selected, this paramenter sets the s(mall)
n(eighborhood) to be used.}

\item{ln}{If the 10-class classification is selected, this paramenter sets the l(arge)
n(eighborhood) to be used.}

\item{n.classes}{"six" or "ten" for a six- or ten-class landform classification.}

\item{add.tpi}{Set to TRUE will return a TPI raster (FALSE is default).}

\item{stand.tpi}{Specifies whether the returned TPI raster will be un- or standardized (FALSE is
default).}
}
\description{
The function allows to perform landform classification on the basis of the Topographic Position
Index calculated from an input Digital Terrain Model ('RasterLayer' class).
}
\details{
The TPI is the difference between the elevation of a given cell and the average elevation of the
surrounding cells in a user defined moving window.\cr For landform classification, the TPI is
first standardized and then thresholded; to isolate certain classes, a slope raster (which is
internally worked out) is also needed.\cr For details about the implemented classification, see:
http://www.jennessent.com/downloads/tpi_documentation_online.pdf.\cr

Two methods are available:\cr -the first (devised by Weiss) produces a 6-class landform
classification comprising:\cr -- valley\cr -- lower slope\cr -- flat slope\cr -- middle slope\cr
-- upper slope\cr -- ridge\cr -the second (devised by Jennes) produces a 10-class classification
comprising:\cr -- canyons, deeply incised streams\cr -- midslope drainages, shallow valleys\cr --
upland drainages, headwaters\cr -- u-shaped valleys\cr -- plains\cr -- open slopes\cr -- upper
slopes, mesas\cr -- local ridges, hills in valleys\cr -- midslope ridges, small hills\cr --
mountain tops, high ridges\cr

The second classification is based on two TPI that make use of two
neighborhoods (moving windows) of different size: a s(mall) n(eighborhood) and a l(arge)
n(eighborhood), defined by the parameters sn and ln.\cr

Besides rasters representing the different landform classes, the function optionally returns the
TPI raster, either un- or standarized.\cr The output rasters are plotted on the R graphic console
and returned by the function (as objects of 'RasterLayer' class) within a list.
}
\examples{
#load a sample Digital Terrain Model
dtm <- raster::raster(system.file("external/maungawhau.grd", package="gdistance"))

#perform the 6-class landform analysis (which is default);
# a moving window of dimension 3 (in terms of cells per side) is used
res <- landfClass(x=dtm, scale=3)

}
\keyword{landfClass}
