% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbcbd_get_series.R
\name{gbcbd_get_series}
\alias{gbcbd_get_series}
\title{Imports time series data from BCB-SGS System (Banco Central do Brasil, sistema de series temporais)}
\usage{
gbcbd_get_series(
  id,
  first.date = Sys.Date() - 10 * 365,
  last.date = Sys.Date(),
  format.data = "long",
  be.quiet = FALSE,
  use.memoise = TRUE,
  cache.path = gbcbd_get_default_cache_folder(),
  do.parallel = FALSE
)
}
\arguments{
\item{id}{Id of time series. The name of the vector sets the name of the series in the output (e.g i.d <- c('SELIC' = 11)).
You can search for ids in the official BCB-SGS webpage <http://www.bcb.gov.br/?sgs>}

\item{first.date}{First date of time series}

\item{last.date}{Last date of time series}

\item{format.data}{The format of the datasets - long (default, series incremented by rows) or wide (series incremented by columns)}

\item{be.quiet}{Logical. Should functions output messages to screen? - FALSE (default) or TRUE}

\item{use.memoise}{Logical. Sets the use of caching system - TRUE (default) or FALSE}

\item{cache.path}{Path to save cache files - 'rbcb2_cache' (default)}

\item{do.parallel}{Logical for parallel data importation - FALSE (default)}
}
\value{
A dataframe with requested datasets
}
\description{
Using BCB's oficial API at <https://www.bcb.gov.br/>, this function will download data for a specific set of ids and dates.
The main advantage is the use of caching and parallel computing for fast operations. You can search for available series at <http://www.bcb.gov.br/?sgs>
}
\examples{

my.id <- c('Taxa de juros - Selic' = 11)
df <- gbcbd_get_series(my.id, cache.path = tempdir())
}
