% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiency.R
\name{are}
\alias{are}
\title{Approximate ARE of an M-type estimator to the least-squares estimator}
\usage{
are(estimator, k, c = NULL)
}
\arguments{
\item{estimator}{M-type estimator (\code{'l2'}, \code{'l1'}, \code{'huber'},
or \code{'tukey'}).}

\item{k}{Dimension of the manifold.}

\item{c}{A positive multiplier, or a vector of them, of \eqn{\sigma}, the
square root of the variance, used in the cutoff parameter for the
\code{'huber'} and \code{'tukey'} estimators; should be \code{NULL} for the
\code{'l2'} or \code{'l1'} estimators.}
}
\value{
Approximate ARE
}
\description{
Approximate asymptotic relative efficiency (ARE) of an M-type estimator to
the least-squares estimator given Gaussian errors, calculated using a tangent
space approximation.
}
\examples{
are('l1', 10)

}
\references{
Shin, H.-Y. and Oh H.-S. (2020). Robust Geodesic Regression.
<arXiv:2007.04518>
}
\seealso{
\code{\link{are_nr}}.
}
\author{
Ha-Young Shin
}
