\name{clustermap}
\alias{clustermap}
\title{Classification of dataset using kmeans.r or hclust.r and representation of clusters on a map.}
\description{
The function `clustermap' performs a classification of the sites from the variables included in $dataset$
and computes a bar plot of the clusters calculated.
Classification methods comes from hclust.R (hierarchical cluster analysis) and kmeans.R (k-means clustering)
and number of class is chosen with $clustnum$.
}
\usage{
clustermap(long,lat,dataset,clustnum,method="kmeans",
           type=NULL,centers=NULL,scale=FALSE,listvar=NULL, listnomvar=NULL,
           carte=NULL,criteria=NULL,labvar="Cluster",
           label="",symbol=0,color=1,labmod="",
           axis=FALSE,lablong="", lablat="")

}
\arguments{
  \item{long}{a vector $x$ of size $n$}
  \item{}{}
  \item{lat}{a vector $y$ of size $n$}
  \item{}{}
  \item{dataset}{matrix of variables of numeric values}
  \item{}{}
  \item{clustnum}{Number of clusters}
  \item{}{}
  \item{method}{two methos : `kmeans' by default or `hclust'}
  \item{}{}
  \item{type}{If method=`hclust'', type=``complete'' by default  (the possibilities are given in help(hclust)
  as `ward', `single', etc). If method=`kmeans', type="Hartigan-Wong" by default (the possibilities are given in help(kmeans)
  as `Forgy', etc)}
  \item{}{}
  \item{centers}{If method='kmeans', user can give a matrix with initial cluster centers.}
  \item{}{}
  \item{scale}{If scale=TRUE, the dataset is reducted.}
  \item{}{}
  \item{listvar}{matrix of variables}
  \item{}{}
  \item{listnomvar}{names of variables $listvar$}
  \item{}{}
  \item{criteria}{a vector of size $n$ of boolean with TRUE on specific sites (these for non interactive selection)}
  \item{}{}
  \item{carte}{matrix with 2 columns for drawing spatial polygonal contours : $x$ and $y$ coordinates of the vertices of the polygon}
  \item{}{}
  \item{labvar}{name of variable $var$}
  \item{}{}
  \item{label}{vector of size $n$ with names of each site}
  \item{}{}
  \item{color}{0 or 1 (by default), choice of representation of selected points. If 0, sites are represented in blue, if 1, sites are represented with different colors for each cluster}
  \item{}{}
  \item{symbol}{0 (by default) or 1, choice of representation of selected points. If 0, selected points are circles, if 1, selected points are stars}
  \item{}{}
  \item{labmod}{names of Clusters}
  \item{}{}
  \item{axis}{a boolean with TRUE for drawing axes on the map}
  \item{}{}
  \item{lablong}{name of the x-axis that will be printed on the map}
  \item{}{}
  \item{lablat}{name of the y-axis that will be printed on the map}
}
\details{
The two windows are interactive : the sites selected by a bar chosen on the bar plot 
are represented on the map in red and the values of sites selected on the map by `points' or `polygon' are 
represented in red on the bar plot. The dendogram is also drawn for 'hclust' method.  
In option, possibility to choose the classification method. 
}
\value{
A vector of boolean of size $n$ (TRUE if the site was in the last selection) and a vector of size $n$ whith the number of cluster for each site
}
\references{Aragon Yves, Perrin Olivier, Ruiz-Gazen Anne, Thomas-Agnan Christine (2006), ``Statistique et Economtrie pour donnes gorfrences : modles et tudes de cas'' \cr \cr

Murtagh, F (1985). ``Multidimensional Clustering Algorithms''. \cr \cr

Hartigan, J. A. and Wong, M. A. (1979). A K-means clustering algorithm. Applied Statistics 28, 100-108}

\author{Thomas-Agnan C., Aragon Y., Ruiz-Gazen A., Laurent T., Robidou L.}

\note{To use the functions hclust.r and kmeans.r, we take many arguments by default.
If the user would like to modify these arguments, he should call these functions first and
then use the function barmap.r to visualize the calculated clusters. }

\seealso{\code{\link{barmap}}, \code{\link{pcamap}}}

\examples{
# donnes oldcol
data(oldcol)
data(oldcol.polys)
contours.OLD<-polylist2list(oldcol.polys)
obs<-clustermap(oldcol$X, oldcol$Y,oldcol[,7:12],3,listvar=oldcol,
listnomvar=names(oldcol),carte=contours.OLD,criteria=(oldcol$CP==1))


# data avifaune 
#library(ade4)
#data(mafragh)
#d<-distchi2(mafragh$flo)

#obs<-clustermap(x<-mafragh$xy[,1],y<-mafragh$xy[,2],d,
#4,method="hclust",type="ward",
#listvar=mafragh$partition,listnomvar="class")

#clas<-obs$vectclass
#e<-by(d,clas,mean)
#g<-rbind(e[1]$'1',e[2]$'2',e[3]$'3',e[4]$'4')


#clustermap(x<-mafragh$xy[,1],y<-mafragh$xy[,2],
#d,4,centers=g,listvar=mafragh$partition,listnomvar="class")
}

\keyword{spatial}
\keyword{multivariate}
