% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GeoLight.R
\name{siteMap}
\alias{siteMap}
\title{Draws sites of residency and adds a convex hull}
\usage{
siteMap(crds, site, type = "points", quantiles = c(0.25, 0.75), hull = T,
  map.range = c("EuroAfrica", "AustralAsia", "America", "World"), ...)
}
\arguments{
\item{crds}{a \code{SpatialPoints} or \code{matrix} object, containing x
and y coordinates (in that order).}

\item{site}{a \code{numerical vector} assigning each row to a particular
period. Stationary periods in numerical order and values >0,
migration/movement periods 0.}

\item{type}{either \emph{points}, or \emph{cross} to show all points for each site or only show the mean position of the site with standard deviation.}

\item{quantiles}{the quantile of the error bars (\emph{cross}) around the median.}

\item{hull}{\code{logical}, if TRUE a convex hull will be plotted around the points of each site.}

\item{map.range}{some possibilities to choose defined areas ("World
(default)", "EuroAfrica","America","AustralAsia").}

\item{...}{Arguments to be passed to methods, such as graphical parameters (see par).}
}
\description{
Draw a map (from the \code{R} Package \code{maps}) showing the defined
stationary sites
}
\details{
Standard graphical paramters like \code{pch}, \code{cex}, \code{lwd}, \code{lty} and \code{col} are implemented.
The color can be specified as either a vector of colors (e.g. c("blue", "red", ...)) or as a character string indicating a color ramp (at the moment only "random" and "rainbow" is available )
}
\examples{
data(hoopoe2)
 hoopoe2$tFirst <- as.POSIXct(hoopoe2$tFirst, tz = "GMT")
 hoopoe2$tSecond <- as.POSIXct(hoopoe2$tSecond, tz = "GMT")
crds <- coord(hoopoe2, degElevation = -6)
filter <- distanceFilter(hoopoe2, distance = 30)
site <- changeLight(hoopoe2, rise.prob = 0.1, set.prob = 0.1, plot = FALSE,
 summary = FALSE)$site
siteMap(crds[filter,], site[filter], xlim=c(-20,20), ylim=c(0,60),
 lwd=2, pch=20, cex=0.5, main="hoopoe2")
}
\author{
Simeon Lisovski & Tamara Emmenegger
}

