% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clan.R
\name{CLAN}
\alias{CLAN}
\title{Performs CLAN}
\usage{
CLAN(
  Z_CLAN,
  membership,
  equal_variances = FALSE,
  diff = setup_diff(),
  significance_level = 0.05
)
}
\arguments{
\item{Z_CLAN}{A numeric matrix holding variables on which classification analysis (CLAN) shall be performed. CLAN will be performed on each column of the matrix.}

\item{membership}{A logical matrix that indicates the group membership of each observation in \code{Z_CLAN}. Needs to be of type \code{\link{quantile_group}}. Typically, the grouping is based on CATE estimates, which are for instance returned by \code{proxy_CATE}.}

\item{equal_variances}{If \code{TRUE}, then all within-group variances of the CLAN groups are assumed to be equal. Default is \code{FALSE}. This specification is required for heteroskedasticity-robust variance estimation on the difference of two CLAN generic targets (i.e. variance of the difference of two means). If \code{TRUE} (corresponds to homoskedasticity assumption), the pooled variance is used. If \code{FALSE} (heteroskedasticity), the variance of Welch's t-test is used.}

\item{diff}{Specifies the generic targets of CLAN. Must be an instance of \code{\link{setup_diff}}. See the documentation of \code{\link{setup_diff}} for details.}

\item{significance_level}{Significance level. Default is 0.05.}
}
\value{
An object of the class \code{CLAN}, consisting of the following components:
\describe{
\item{\code{generic_targets}}{A list of result matrices for each variable in \code{Z_CLAN}. Each matrix contains inferential results on the CLAN generic targets.}
\item{\code{coefficients}}{A matrix of point estimates of each CLAN generic target parameter.}
}
}
\description{
Performs Classification Analysis (CLAN) on all variables in a design matrix.
}
\examples{
## generate data
set.seed(1)
n  <- 150                              # number of observations
p  <- 5                                # number of covariates
Z_CLAN <- matrix(runif(n*p), n, p)     # design matrix to perform CLAN on
membership <- quantile_group(rnorm(n)) # group membership

## perform CLAN
CLAN(Z_CLAN, membership)

}
\references{
Chernozhukov V., Demirer M., Duflo E., Fernández-Val I. (2020). \dQuote{Generic Machine Learning Inference on Heterogenous Treatment Effects in Randomized Experiments.} \emph{arXiv preprint arXiv:1712.04802}. URL: \url{https://arxiv.org/abs/1712.04802}.
}
\seealso{
\code{\link{quantile_group}},
\code{\link{setup_diff}}
}
