% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMC_tpm.R
\name{MMC_tpm}
\alias{MMC_tpm}
\title{Transition Probability Matrices}
\usage{
MMC_tpm(s, x, value = max(x), result)
}
\arguments{
\item{s}{numerical matrix with categorical data sequences}

\item{x}{exogeneous variable}

\item{value}{fixed value of x}

\item{result}{result from the function \code{\link[GenMarkov:mmcx]{mmcx()}}}
}
\value{
The function returns a numerical array with the probability transition matrices for each equation
}
\description{
This functions allows to obtain the transition probability matrices for a specific value of x, considering the estimates obtained from \code{\link[GenMarkov:mmcx]{mmcx()}}.
}
\examples{
data(stockreturns)
s <- cbind(stockreturns$sp500, stockreturns$djia)
x <- stockreturns$spread_1
res <- mmcx(s, x, initial = c(1, 1))
tpm <- MMC_tpm(s, x, value = max(x), result = res)
}
\author{
Carolina Vasconcelos and Bruno Damásio
}
