% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dwp_functions.R
\name{rdwp}
\alias{rdwp}
\title{Simulate parameters from a fitted dwp model}
\usage{
rdwp(n, model)
}
\arguments{
\item{n}{the number of simulation draws}

\item{model}{A \code{\link{dwpm}} object (which is returned from
\code{dwpm()})}
}
\value{
array of \code{n} simulated \code{dwp} values for each unit.
 Dimensions = c(n, number of units).
}
\description{
Simulate parameters from a \code{\link{dwpm}} model object
}
\details{
If the model type = \code{data}, then the number of simulated columns
 must be either \code{>=n} (in which case the first n colunms are taken as the
 simulated DWP) or 1 (in which case, DWP is assumed constant).
}
