% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussSuppressionTwoWay.R
\name{GaussSuppressionTwoWay}
\alias{GaussSuppressionTwoWay}
\title{Two-way iteration variant of \code{\link{GaussSuppressionFromData}}}
\usage{
GaussSuppressionTwoWay(
  data,
  dimVar = NULL,
  freqVar = NULL,
  numVar = NULL,
  weightVar = NULL,
  charVar = NULL,
  hierarchies,
  formula = NULL,
  maxN = suppressWarnings(formals(c(primary)[[1]])$maxN),
  protectZeros = suppressWarnings(formals(c(primary)[[1]])$protectZeros),
  secondaryZeros = suppressWarnings(formals(candidates)$secondaryZeros),
  candidates = CandidatesDefault,
  primary = PrimaryDefault,
  forced = NULL,
  hidden = NULL,
  singleton = SingletonDefault,
  singletonMethod = ifelse(secondaryZeros, "anySumNOTprimary", "anySum"),
  printInc = TRUE,
  output = "publish",
  preAggregate = is.null(freqVar),
  colVar = names(hierarchies)[1],
  removeEmpty = TRUE,
  inputInOutput = TRUE,
  candidatesFromTotal = TRUE,
  structuralEmpty = FALSE,
  freqVarNew = rev(make.unique(c(names(data), "freq")))[1],
  ...
)
}
\arguments{
\item{data}{Input data as a data frame}

\item{dimVar}{The main dimensional variables and additional aggregating variables. This parameter can be  useful when hierarchies and formula are unspecified.}

\item{freqVar}{A single variable holding counts (name or number).}

\item{numVar}{Other numerical variables to be aggregated}

\item{weightVar}{weightVar Weights (costs) to be used to order candidates for secondary suppression}

\item{charVar}{Other variables possibly to be used within the supplied functions}

\item{hierarchies}{List of hierarchies, which can be converted by \code{\link{AutoHierarchies}}.
Thus, the variables can also be coded by \code{"rowFactor"} or \code{""}, which correspond to using the categories in the data.}

\item{formula}{A model formula}

\item{maxN}{Suppression parameter. See \code{GaussSuppressionFromData}.}

\item{protectZeros}{Suppression parameter. See \code{GaussSuppressionFromData}.}

\item{secondaryZeros}{Suppression parameter. See \code{GaussSuppressionFromData}.}

\item{candidates}{GaussSuppression input or a function generating it (see details) Default: \code{\link{CandidatesDefault}}}

\item{primary}{GaussSuppression input or a function generating it (see details) Default: \code{\link{PrimaryDefault}}}

\item{forced}{GaussSuppression input or a function generating it (see details)}

\item{hidden}{GaussSuppression input or a function generating it (see details)}

\item{singleton}{NULL or a function generating GaussSuppression input (logical vector not possible) Default: \code{\link{SingletonDefault}}}

\item{singletonMethod}{\code{\link{GaussSuppression}} input}

\item{printInc}{\code{\link{GaussSuppression}} input}

\item{output}{One of \code{"publish"} (default), \code{"inner"}.
Here "inner" means input data (possibly pre-aggregated).}

\item{preAggregate}{When \code{TRUE}, the data will be aggregated within the function to an appropriate level.
This is defined by the dimensional variables according to \code{dimVar}, \code{hierarchies} or \code{formula} and in addition \code{charVar}.}

\item{colVar}{Hierarchy variables for the column groups (others in row group).}

\item{removeEmpty}{When TRUE (default) empty output corresponding to empty input is removed.
When NULL, removal only within the algorithm (x  matrices) so that such empty outputs are never secondary suppressed.}

\item{inputInOutput}{Logical vector (possibly recycled) for each element of hierarchies.
TRUE means that codes from input are included in output. Values corresponding to \code{"rowFactor"} or \code{""} are ignored.}

\item{candidatesFromTotal}{When TRUE (default), same candidates for all rows and for all columns, computed from row/column totals.}

\item{structuralEmpty}{See \code{GaussSuppressionFromData}.}

\item{freqVarNew}{Name of new frequency variable generated when input \code{freqVar} is NULL and \code{preAggregate} is TRUE.
Default is \code{"freq"} provided this is not found in \code{names(data)}.}

\item{...}{Further arguments to be passed to the supplied functions.}
}
\value{
Aggregated data with suppression information
}
\description{
Internally, data is organized in a two-way table.

Use parameter \code{colVar} to choose hierarchies for columns (others will be rows). Iterations start by column by column suppression.
The algorithm utilizes \code{\link{HierarchyCompute2}}.

With two-way iterations, larger data can be handled, but there is a residual risk.
The method is a special form of linked-table iteration.
Separately, the rows and columns are protected by \code{\link{GaussSuppression}} and they have common suppressed cells.
}
\details{
The supplied functions for generating \code{\link{GaussSuppression}} input behave as in \code{\link{GaussSuppressionFromData}} with some exceptions.
When \code{candidatesFromTotal} is \code{TRUE} (default) the candidate function will be run locally once for rows and once for columns. Each time based on column or row totals.
The global x-matrix will only be generated if one of the functions supplied needs it.
Non-NULL singleton can only be supplied as a function. This function will be run locally within the algorithm before each call to \code{\link{GaussSuppression}}.

Note that a difference from \code{GaussSuppressionFromData} is that parameter \code{removeEmpty} is set to \code{TRUE} by default.

Another difference is that duplicated combinations is not allowed. Normally duplicates are avoided by setting \code{preAggregate} to \code{TRUE}.
When the \code{charVar} parameter is used, this can still be a problem. See the examples for a possible workaround.
}
\examples{
z3 <- SSBtoolsData("z3")

dimListsA <- SSBtools::FindDimLists(z3[, 1:6])
dimListsB <- SSBtools::FindDimLists(z3[, c(1, 4, 5)])

set.seed(123)
z <- z3[sample(nrow(z3),250),]

\dontrun{
out1 <- GaussSuppressionTwoWay(z, freqVar = "ant", hierarchies = dimListsA, 
                               colVar = c("hovedint"))
}                                
out2 <- GaussSuppressionTwoWay(z, freqVar = "ant", hierarchies = dimListsA, 
                               colVar = c("hovedint", "mnd"))
out3 <- GaussSuppressionTwoWay(z, freqVar = "ant", hierarchies = dimListsB, 
                               colVar = c("region"))
out4 <- GaussSuppressionTwoWay(z, freqVar = "ant", hierarchies = dimListsB, 
                               colVar = c("hovedint", "region"))
                               
# "mnd" not in  hierarchies -> duplicated combinations in input 
# Error when  preAggregate is FALSE: Index method failed. Duplicated combinations?
out5 <- GaussSuppressionTwoWay(z, freqVar = "ant", hierarchies = dimListsA[1:3], 
                               protectZeros = FALSE, colVar = c("hovedint"), preAggregate = TRUE)


# charVar needed -> Still problem when preAggregate is TRUE
# Possible workaround by extra hierarchy 
out6 <- GaussSuppressionTwoWay(z, freqVar = "ant", charVar = "mnd2",
                               hierarchies = c(dimListsA[1:3], mnd2 = "Total"), # include charVar 
                               inputInOutput = c(TRUE, TRUE, FALSE),  # FALSE -> only Total 
                               protectZeros = FALSE, colVar = c("hovedint"),
                               preAggregate = TRUE,  
                               hidden = function(x, data, charVar, ...) 
                                 as.vector((t(x) \%*\% as.numeric(data[[charVar]] == "M06M12")) == 0))                                
}
