% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeLinearNColorGradientFunction.R
\name{makeLinearNColorGradientFunction}
\alias{makeLinearNColorGradientFunction}
\title{makeLinearNColorGradientFunction}
\usage{
makeLinearNColorGradientFunction(
  colors = c("#000000", "#CCCC00", "#FF0000"),
  x.min = 0,
  x.max = 100
)
}
\arguments{
\item{colors}{A vector of colors, either by name or as hexadecimal colors.}

\item{x.min}{The minimal value for the range of numbers to be encoded.}

\item{x.max}{The maximal value for the range of numbers to be encoded.}
}
\value{
Returns a function encoding a single numerical value as a numerical vector of length 3 containing
RGB values from 0 to 255.
}
\description{
Given a set of colors and a range of values, generate a function to encode numbers in
the specified range of colors. This serves as a backend for \code{makeOneColorEncodeFunction()}
\code{makeTwoColorEncodeFunction()} allowing more than 2 color intervals can be specified, so
that color encodings consisting of 3 or more colors per color-dimension/channel can be created.
}
\details{
Given n colors, where n >=1 and a range of numbers from x.min to x.max, the function breaks
down the range of numbers into n-1 ranges, and then maps numerical values linearly to numbers in each
range bounded by successive colors. This is used by the functions \code{\link{makeOneColorEncodeFunction}()}
and \code{\link{makeTwoColorEncodeFunction}()}.
}
\examples{

three_col_fun <- makeLinearNColorGradientFunction( colors = c("blue", "white", "red"),
                                                    x.min = 0,
                                                     x.max = 100 )

three_col_mat <- t( sapply( c(0, 25, 50, 75, 100 ) ,three_col_fun ) )

}
\seealso{
\code{\link{makeOneColorEncodeFunction}()},
\code{\link{makeTwoColorEncodeFunction}()}.
}
