% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{GROAN.run}
\alias{GROAN.run}
\title{Compare Genomic Regressors on a Noisy Dataset}
\usage{
GROAN.run(nds, wb, run.id = createRunId())
}
\arguments{
\item{nds}{a GROAN.NoisyDataSet object, containing the data (genotypes, phenotypes and so forth) plus a \code{noiseInjector} function}

\item{wb}{a GROAN.Workbench object, containing the regressors to be tested together with the description of the experiment}

\item{run.id}{an alphanumeric string identifying this specific run. If not passed it is generated using \link{createRunId}}
}
\value{
a \code{GROAN.Result} object
}
\description{
This function runs the experiment described in a \link[=createWorkbench]{GROAN.Workbench} object on
the data contained in a \link[=createNoisyDataset]{GROAN.NoisyDataSet} object. It returns a \code{GROAN.Result}
object, which have a \link[=summary.GROAN.Result]{summary} function for quick inspection and can be
fed to \link{plotResult} for visual comparisons. The experiment statistics are computed via \link{measurePredictionPerformance}.\cr
Each time this function is invoked it will refer to a \code{runId} - an alphanumeric string identifying
each specific run. The \code{runId} is usually generated internally, but it is possible to pass it if
the intention is to join results from different runs for analysis purposes.
}
\examples{
\dontrun{
#Complete examples are found in the vignette
vignette('GROAN.vignette', package='GROAN')

#Minimal example
#1) creating a noisy dataset with normal noise
nds = createNoisyDataset(
  name = 'PEA, normal noise',
  genotypes = GROAN.pea.SNPs,
  phenotypes = GROAN.pea.yield,
  noiseInjector = noiseInjector.norm,
  mean = 0,
  sd = sd(GROAN.pea.yield) * 0.5
)

#2) creating a GROAN.WorkBench using default regressor and crossvalidation preset
wb = createWorkbench()

#3) running the experiment
res = GROAN.run(nds, wb)

#4) examining results
summary(res)
plotResult(res)
}
}
\seealso{
\link{measurePredictionPerformance}
}
