% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vecchia_laplace_NR.R
\name{vecchia_laplace_prediction}
\alias{vecchia_laplace_prediction}
\title{Wrapper for VL version of vecchia_prediction}
\usage{
vecchia_laplace_prediction(vl_posterior, vecchia.approx, covparms,
  pred.mean = 0, var.exact = FALSE, covmodel = "matern",
  return.values = "all")
}
\arguments{
\item{vl_posterior}{a posterior estimate object produced by calculate_posterior_VL}

\item{vecchia.approx}{a vecchia object as generated by vecchia_specify()}

\item{covparms}{covariance parameters as a vector}

\item{pred.mean}{provides the prior latent mean for the prediction locations}

\item{var.exact}{should prediction variances be computed exactly, or is a (faster) approximation acceptable}

\item{covmodel}{covariance model, 'matern' by default.}

\item{return.values}{either 'mean' only, 'meanvar', 'meanmat', or 'all'}
}
\value{
(multivariate normal) loglikelihood implied by the Vecchia approximation
}
\description{
Wrapper for VL version of vecchia_prediction
}
\examples{
z=rnorm(10); locs=matrix(1:10,ncol=1); vecchia.approx=vecchia_specify(locs,m=5)
vl_posterior = calculate_posterior_VL(z,vecchia.approx,"gaussian",covparms=c(1,2,.5))
locs.pred=matrix(1:10+.5,ncol=1)
vecchia.approx.pred = vecchia_specify(locs, m=5, locs.pred=locs.pred )
vecchia_laplace_prediction(vl_posterior,vecchia.approx.pred,covparms=c(1,2,.5))
}
