% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p2dMax.R
\name{p2dMax}
\alias{p2dMax}
\title{p2dMax : provides the maximum polynomial degree \code{dMax}
given the number of variables \code{nVar} and the number of possible
polynomial terms \code{pMax}.}
\usage{
p2dMax(nVar, pMaxKnown)
}
\arguments{
\item{nVar}{Number of variables considered in the polynomial formulation.}

\item{pMaxKnown}{The number of polynomial terms}
}
\value{
\code{dMax} The maximum polynomial degree
}
\description{
Find the maximum polynomial degree \code{dMax}
             given the number of polynomial terms \code{pMax}
             and the system dimension \code{nVar}.
}
\examples{
#############
# Example 1 #
#############
# Maximum polynomial degree ?
# number of variables:
nVar <- 3
# size of the polynomial vector:
pMax <- 10
# The maximal polynomial degree used for coding the polynomial is:
p2dMax(nVar,pMax)

#############
# Example 2 #
#############
# for pMax = 462 and nVar = 6, then dMax is:
p2dMax(6,462)
# indeed:
length(poLabs(nVar=6, dMax=5))

}
\seealso{
\code{\link{gloMoId}}, \code{\link{gPoMo}}, \code{\link{poLabs}}
}
\author{
Sylvain Mangiarotti, Laurent Drapeau
}
