% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numinoisy.R
\name{numinoisy}
\alias{numinoisy}
\title{numinoisy : Generates time series of deterministic-behaviour
stochatically-perturbed}
\usage{
numinoisy(x0, t, K, varData = NULL, txVarBruitA = NULL,
  txVarBruitM = NULL, varBruitA = NULL, varBruitM = NULL, taux = NULL,
  freq = NULL, variables = NULL, method = NULL)
}
\arguments{
\item{x0}{Initial conditions. Should be a vector which size must be equal
to the model dimension \code{dim(K)[2]} (the number of variables of the
model defined by matrix K).}

\item{t}{A vector providing all the dates for which the output are expected.}

\item{K}{The Ordinary Differential Equations used to model the dynamics.
The number of column should correspond to the number of variables, the
number of lines should correspond to the number of parameters ordered
following the convention defined by \code{poLabs(nVar,dMax)}, with nVar
the number of variables and dMax the maximum polynomial degree allowed.}

\item{varData}{A vector of size nVar providing the caracteristic variances
of each variable of the dynamical systems in ODE defined by matrix K.
If not provided, this variance is automatically estimated.}

\item{txVarBruitA}{A vector defining the ratio of ADDITIVE noise
for each variable of the dynamical system in ODE. The additive noise is
added at the end of the numerical integration process. The ratio is
defined relatively to the signal variance of each variable.}

\item{txVarBruitM}{A vector defining the ratio of MULTIPLICATIVE
noise for each variable of the dynamical system in ODE. The multiplicative
noise is a perturbation added at each numerical integration step. The
ratio is defined relatively to the signal variance of each variable.}

\item{varBruitA}{A vector defining the variance of ADDITIVE noise
for each variable of the dynamical system in ODE. The additive noise is
added at the end of the numerical integration process.}

\item{varBruitM}{A vector defining the ratio of MULTIPLICATIVE
noise for each variable of the dynamical system in ODE. The multiplicative
noise is a perturbation added at each numerical integration step.}

\item{taux}{Generates random gaps in time series. Parameter \code{taux}
defines the ratio of data to be kept (e.g. for \eqn{taux=0.75}, 75 percents
of the data are kept).}

\item{freq}{Undesamples the time series. Parameter \code{freq} defines the
periodicity of data kept (e.g. for \eqn{freq=3}, 1 data out of 3 is kept).}

\item{variables}{Defines which variables must be generated.}

\item{method}{Defines the numerical integration method to be used. See
function \code{ode} from package \code{deSolve} for details.}
}
\value{
A list of two variables: \cr

\code{$donnees} the integrated trajectory (first column is the time,
next columns are the model variables) \cr

\code{$idices} \cr

\code{$signal_init} the integrated trajectory (first column is the time,
next columns are the model variables) \cr

\code{$bruitM} The level of multiplicative noise \cr

\code{$bruitA} The level of additive noise \cr

\code{$vectBruitM} The multiplicative noise used to produce the time series \cr

\code{$vectBruitA} The additive noise used to produce the time series \cr

\code{$ecart_type} The level standard deviation \cr
}
\description{
Generates time series from Ordinary Differential Equations
perturbed by multiplicative and/or additive noises
}
\examples{
#############
# Example 1 #
#############
# Rossler Model formulation
# The model dimension
nVar = 3
 # maximal polynomial degree
dMax = 2
a = 0.520
b = 2
c = 4
Eq1 <- c(0,-1, 0,-1, 0, 0, 0, 0, 0, 0)
Eq2 <- c(0, 0, 0, a, 0, 0, 1, 0, 0, 0)
Eq3 <- c(b,-c, 0, 0, 0, 0, 0, 1, 0, 0)
K <- cbind(Eq1, Eq2, Eq3)
# Edit the equations
visuEq(nVar, dMax, K)
# initial conditions
v0 <- c(-0.6, 0.6, 0.4)
# output time required
timeOut = (0:1000)/50
# variance of additive noise
varBruitA = c(0,0,0)^2
# variance of multiplitive noise
varBruitM = c(2E-2, 0, 2E-2)^2
# numerical integration with noise
intgr <- numinoisy(v0, timeOut, K, varBruitA = varBruitA, varBruitM = varBruitM, freq = 1)
# Plot of the simulated time series obtained
dev.new()
plot(intgr$donnees[,2], intgr$donnees[,3], type='l',
      main='phase portrait', xlab='x(t)', ylab = 'y(t)')
dev.new()
par(mfrow = c(3, 1))
plot(intgr$donnees[,1], intgr$donnees[,2], type='l',
      main='phase portrait', xlab='x(t)', ylab = 'y(t)')
lines(intgr$donnees[,1], intgr$vectBruitM[,2]*10, type='l',
      main='phase portrait', xlab='x(t)', ylab = 'e(t)*10', col='red')
plot(intgr$donnees[,1], intgr$donnees[,3], type='l',
      main='phase portrait', xlab='x(t)', ylab = 'y(t)')
lines(intgr$donnees[,1], intgr$vectBruitM[,3]*10, type='l',
      main='phase portrait', xlab='x(t)', ylab = 'e(t)*10', col='red')
plot(intgr$donnees[,1], intgr$donnees[,4], type='l',
      main='phase portrait', xlab='x(t)', ylab = 'y(t)')
lines(intgr$donnees[,1], intgr$vectBruitM[,4]*10, type='l',
      main='phase portrait', xlab='x(t)', ylab = 'e(t)*10', col='red')

}
\author{
Sylvain Mangiarotti, Malika Chassan
}

