% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DkyCalc.R
\name{DkyCalc}
\alias{DkyCalc}
\title{DkyCalc : computes the Kaplan-Yorke dimension}
\usage{
DkyCalc(methodName, nVar, lyapExp)
}
\arguments{
\item{methodName}{The method that was used to compute the lyapunov exponents}

\item{nVar}{The model dimension (which corresponds to the number of exponents)}

\item{lyapExp}{Time series of the local Lyapunov exponents spectrum (one column
for each exponent)}
}
\description{
Computes the Kaplan-Yorke dimension
from the Lyapunov exponents (Kaplan and Yorke 1979).
}
\examples{
#' Load the global model (here for Ebola Virus Diesease)
data(Ebola)
nVar = dim(Ebola$KL)[2]
pMax = dim(Ebola$KL)[1]
dMax = p2dMax(nVar, pMax)
#' Compute the time series of Lyapunov exponents
outLyapFD <- NULL
outLyapFD$Wolf <- lyapFDWolf(outLyapFD$Wolf, nVar= nVar, dMax = dMax,
                             coeffF = Ebola$KL,
                             tDeb = 0, dt = 0.01, tFin = 2,
                             yDeb = Ebola$yDeb)
#' estimate the Kaplan-Yorke dimension
DkyCalc(methodName = "Wolf", nVar= 3, lyapExp = outLyapFD$Wolf$lyapExpLoc)

}
\references{
Kaplan, J. & Yorke, J., Chaotic behavior of multidimensional difference equations.
In: Peitgen H. O. and Walther H. O., "Functional Differential Equations and
the Approximation of Fixed Points", Lecture Notes in Mathematics. 730.
Berlin: Springer. p. 204-227, 1979.
}
