% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnrs_metadata.R
\name{GNRS_metadata}
\alias{GNRS_metadata}
\title{Get GNRS metadata}
\usage{
GNRS_metadata(bibtex_file = NULL, ...)
}
\arguments{
\item{bibtex_file}{Optional output file for writing bibtex citations.}

\item{...}{Additional parameters passed to internal functions}
}
\value{
List containing: (1) bibtex-formatted citation information,
(2) information about GNRS data sources,
(3) GNRS version information, and
(4) information that can be used in an acknowledgments statement..
}
\description{
Returns metadata on GNRS including version and citation information
}
\note{
This function provides citation information in bibtex format that can be used with reference manager software (e.g. Paperpile, Zotero). Please remember to cite both the sources and the GNRS, as the GNRS couldn't exist without these sources!

This function is a wrapper that returns the output of the functions GNRS_citations, GNRS_sources, GNRS_version, and GNRS_acknowledgments.
}
\examples{
\dontrun{
metadata <- GNRS_metadata()
}

}
