% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DFA_test.r
\name{dfa.test}
\alias{dfa.test}
\title{Statistical test for Detrended Fluctuation Analysis.}
\usage{
dfa.test(y, npoints, rep, ts.sim, prob)
}
\arguments{
\item{y}{A vector contaning univariate time series.}

\item{npoints}{The number of different window sizes that will be used to estimate the Fluctuation function in each zone. See nonlinearTseries package.}

\item{rep}{An integer value indicating the number of repetitions.}

\item{ts.sim}{An logical value. If TRUE, the confidence interval for alpha_dfa is obtained from a White Gaussian Noise. If FALSE, the confidence interval for alpha_dfa is obtained from the shuffling of the original series.}

\item{prob}{An numeric value indicating the quantile of probability to be used in estimating confidence intervals by N(0,1).}
}
\value{
An rbind matrix containing "alpha_dfa","se_alpha_dfa", "r2_alpha_dfa","min_alpha_dfa","max_test","mean_test", "median_test", "sd_test", "skewness_test", "kurtosis_test", "jarquebera_test_pvalue", and confidence interval: "CI_lower_test", "CI_upper_test".
}
\description{
This function performs the statistical test for the long-range correlation exponents obtained by the Detrended Fluctuation Analysis method.
}
\details{
This function include following measures alpha_dfa, se_alpha_dfa, r2_alpha_dfa, min_test, max_test, mean_test, median_test, sd_test, skewness_test, kurtosis_test, Jarquebera_test_pvalue, CL_lower_test, CL_upper_test
}
\examples{
y=rnorm(1000)
dfa.test(y, npoints=15, rep=10,ts.sim="TRUE", prob=.95)

}
\references{
KRISTOUFEK, L. Rescaled Range Analysis and Detrended Fluctuation Analysis: Finite Sample Properties and Confidence Intervals. AUCO Czech Economic Review, v.4,n.3, p.315-329, 2010.
}
