% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manager.R
\name{manager}
\alias{manager}
\title{Manager model}
\usage{
manager(
  RESOURCES = NULL,
  AGENTS = NULL,
  LAND = NULL,
  PARAS = NULL,
  COST = NULL,
  ACTION = NULL,
  INTERACT = NULL,
  inter_tabl = NULL,
  OBSERVATION = NULL,
  model = "IBM"
)
}
\arguments{
\item{RESOURCES}{The resources array produced by the resource function within GMSE}

\item{AGENTS}{The array of agents produced in the main gmse() function}

\item{LAND}{The landscape array on which interactions between resources and agents occur}

\item{PARAS}{The vector of parameters that hold global and dynamic parameter values used by GMSE}

\item{COST}{A three dimensional array of cost values for agent (manager and stakeholder) actions}

\item{ACTION}{A three dimensional array of agent (manager and stakeholder) actions}

\item{INTERACT}{An interaction (Jacobian) matrix of resources & landscape layer effects}

\item{inter_tabl}{Interaction table indexing types with the INTERACT matrix}

\item{OBSERVATION}{The array of resource observations from the observation model, used to estimate abundance of resources}

\item{model}{The type of model being applied (Currently only individual-based
-- i.e., 'agent-based' -- models are allowed)}
}
\value{
The manager function outputs an R list that includes five separate arrays, including (1) an new RESOURCES array, (2) a new AGENTS array, (3) a new LAND array, (4) a new ACTIONS array, and a new (5) COST array, each of which might be affected by the user function. The new arrays can then be read back into the broader GMSE function, thereby affecting the input into the user, resource, and observation models.
}
\description{
A model of manager decisions for a single time step. Managers set costs for user actions.
}
\examples{
\dontrun{
MANAGER_OUT <- run_manage(RESOURCE_c = RESOURCES, LANDSCAPE_c = LAND, 
PARAMETERS_c = PARAS, AGENT_c = AGENTS, COST_c = COST, ACTION_c = ACTION, 
JACOBIAN_c = INTERACT, INTERACT_c = inter_tabl, OBSERVATION_c = OBSERVATION);
}
}
