% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/inv.logit.R, R/logit.R
\name{inv.logit}
\alias{inv.logit}
\alias{logit}
\title{Logit and inverse logit transforms}
\usage{
inv.logit(a)

logit(p)
}
\arguments{
\item{a}{A vector of real values.}

\item{p}{A vector of probabilities.}
}
\value{
\code{inv.logit} returns a vector of the same length as \code{a} of the
  inverse logit transformed values. This function is also known as the
  expit-function.

\code{logit} returns a vector of the same length as \code{p} with
  the log odds of \code{p}.
}
\description{
The logit transformation (i.e. the log of the odds) and its inverse (also
called expit).
}
\examples{
p <- runif(100)
print(a <- GMCM:::logit(p))
p - GMCM:::inv.logit(a)
}
\author{
Anders Ellern Bilgrau <anders.ellern.bilgrau@gmail.com>
}
\seealso{
Used in \code{\link{tt}} and \code{\link{inv.tt}}.
}
\keyword{internal}

