% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.RRglmerMod}
\alias{plot.RRglmerMod}
\title{Plot diagnostics for a RRglmerMod object}
\usage{
\method{plot}{RRglmerMod}(x, which = c(1, 3, 4, 5), ...)
}
\arguments{
\item{x}{an object of class RRglmerMod.}

\item{which}{if a subset of the plots is required, specify a subset of the numbers 1:5 (default: 1, 3, 4, 5).}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Five plots (selectable by \code{which}) are currently available: (1) a plot of estimated population prevalence per RR model,
(2) a plot of estimated population prevalence per protection level,
(3) a plot of random effects and their conditional variance (95%-cI),
(4) a plot of conditional pearson residuals against predicted honest response,
and (5) a plot of unconditional pearson residuals against predicted honest response.
By default, plots 1, 3, 4 and 5 are provided.
Reference: Fox, J-P, Klotzke, K. and Veen, D. (2016). \emph{Generalized Linear Mixed Models for Randomized
Responses.} Manuscript submitted for publication.
}
\examples{
out <- RRglmer(response ~ Gender + RR + pp + (1+pp|age), link="RRlink.logit", RRmodel=RRmodel,
         p1=RRp1, p2=RRp2, data=Plagiarism, na.action = "na.omit",
         etastart = rep(0.01, nrow(Plagiarism)),
         control = glmerControl(optimizer = "Nelder_Mead", tolPwrss = 1e-03), nAGQ = 1)
plot(out, which = 1:5)
}

