% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_traits_tax.R
\name{GIFT_traits_tax}
\alias{GIFT_traits_tax}
\title{Traits at the taxonomic level}
\usage{
GIFT_traits_tax(
  trait_IDs = "",
  agreement = 0.66,
  bias_ref = TRUE,
  bias_deriv = TRUE,
  api = "https://gift.uni-goettingen.de/api/extended/",
  GIFT_version = "latest"
)
}
\arguments{
\item{trait_IDs}{a character string indicating which trait you want to
retrieve. Traits must belong to the available list of traits.}

\item{agreement}{Percentage of resources that agree on an aggregated trait
value, entries below this threshold will be omitted.}

\item{bias_ref}{When \code{FALSE}, exclude entries that are only based on a
resource that potentially introduces a bias (e.g. a resource only including
trees).}

\item{bias_deriv}{When \code{FALSE}, exclude entries that are only based on a
derivation that potentially introduces a bias (e.g. all phanerophytes being
woody but some life forms being ambiguous).}

\item{api}{character string defining from which API the data will be
retrieved.}

\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the \code{latest} stable
version. If set to \code{beta}, the most up-to-date version which is still
subject to changes and edits is used.}
}
\value{
A long-format data frame with 7 columns: \code{taxon_ID}, \code{taxon_name},
\code{trait_value}, \code{agreement}, \code{references} and \code{negative}.
}
\description{
Retrieve specific trait values at a high taxonomic level.
}
\details{
Here is the detail of each column:

\emph{taxon_ID} - Identification number of the taxon\cr
\emph{taxon_name} - Name of the taxon\cr
\emph{agreement} - Agreement score between the different sources for that
trait value, only for categorical traits\cr
\emph{references} - Source of the trait values (\code{ref_ID})\cr
\emph{negative} - Does the record indicate the absence of trait value in
taxon_ID\cr

and then one column per trait with the respective trait values
}
\examples{
\donttest{
ex <- GIFT_traits_tax(trait_IDs = c("1.2.1", "1.4.1"),
bias_ref = FALSE, bias_deriv = FALSE)
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Denelle, P., Weigelt, P., & Kreft, H. (2023). GIFT—An R package to
 access the Global Inventory of Floras and Traits. Methods in Ecology
 and Evolution, 14, 2738-2748.
 https://doi.org/10.1111/2041-210X.14213

 Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_traits_meta]{GIFT_traits_meta()}}
}
