% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stations.R
\name{stations}
\alias{stations}
\title{Get GHCNd Inventory}
\usage{
stations(
  filename,
  variables = c("tmin", "tmax", "prcp"),
  first_year,
  last_year
)
}
\arguments{
\item{filename}{Character, the filename of the inventory, if already downloaded.}

\item{variables}{Character, vector of the variables to include.}

\item{first_year}{Integer, the year since when data should be recorded.}

\item{last_year}{Integer, the year until when data should be recorded.}
}
\value{
The table with the GHCNd stations.
}
\description{
Get GHCNd Inventory
}
\details{
If \emph{filename} is not provided, this will download the inventory from
<"https://www.ncei.noaa.gov/pub/data/ghcn/daily/ghcnd-inventory.txt">.
In alternative, you can download the invetory yourself and load it (see examples).
}
\examples{
\dontrun{
dest <- tempfile()
download_inventory(dest)
s <- stations(dest)
}
}
