g.part3 = function(metadatadir=c(),f0,f1,anglethreshold = 5,timethreshold = 5, 
                   acc.metric="ENMO",ignorenonwear=FALSE,overwrite=FALSE,desiredtz="Europe/London",
                   constrain2range=TRUE,do.part3.pdf=TRUE) {
  # description: function to apply sleep detection functions to milestone data generated by g.part1
  #------------------------------------
  # create output directory if it does not exist
  if (file.exists(paste(metadatadir,sep=""))) {
  } else {
    dir.create(file.path(metadatadir))
  }
  if (file.exists(paste(metadatadir,"/meta/ms3.out",sep=""))) {
  } else {
    dir.create(file.path(paste(metadatadir,"/meta",sep=""),"ms3.out"))
    dir.create(file.path(paste(metadatadir,"/meta",sep=""),"sleep.qc"))
  }
  #------------------------------------------------------
  fnames  =dir(paste(metadatadir,"/meta/basic",sep=""))
  if (f1 > length(fnames) | f1 == 0) f1 = length(fnames)
  if (f0 > length(fnames) | f0 == 0) f0 = 1
  #========================================================================
  # check which files have already been processed, such that no double work is done
  # ffdone a matrix with all the binary filenames that have been processed
  ffdone = fdone = dir(paste(metadatadir,"/meta/ms3.out",sep=""))
  if (length(fdone) > 0) {
    for (ij in 1:length(fdone)) {
      tmp = unlist(strsplit(fdone[ij],".RData"))
      ffdone[ij] = tmp[1]
    }
  } else {
    ffdone = c()
  }
  nightsperpage =7
  for (i in f0:f1) {
    FI = file.info(paste(metadatadir,"/meta/basic/",fnames[i],sep=""))
    if (is.na(FI$size) == TRUE) FI$size = 0
    if (FI$size == 0 | is.na(FI$size) == TRUE | length(FI$size) == 0) {
      cat(paste("P3 file ",fnames[i],sep=""))
      cat("Filename not recognised")
    }
    fname = unlist(strsplit(fnames[i],".RData"))[1]
    fname = unlist(strsplit(fname,"eta_"))[2]
    #=========================================================
    #check whether file has already been processed
    #by comparing filename to read with list of processed files
    if (length(ffdone) > 0) {
      if (length(which(ffdone == fname)) > 0) { 
        skip = 1 #skip this file because it was analysed before")
      } else {
        skip = 0 #do not skip this file
      }
    } else {
      skip = 0
    }
    if (overwrite == TRUE) skip = 0
    if (skip == 0) {  
      # Load previously stored meta-data from part1.R
      cat(paste(" ",i,sep=""))
      M = c()
      load(paste(metadatadir,"/meta/basic/",fnames[i],sep=""))
      if (M$filecorrupt == FALSE & M$filetooshort == FALSE) {
        IMP = g.impute(M,I,strategy=1,hrs.del.start=0,hrs.del.end=0,maxdur=0)
        SLE = g.sib.det(M,IMP,I,twd=c(-12,12),timethreshold=timethreshold,anglethreshold=anglethreshold,
                        acc.metric=acc.metric,desiredtz=desiredtz,constrain2range=constrain2range)
        L5list = SLE$L5list
        lightson = SLE$lightson
        lightsout = SLE$lightsout
        tib.threshold = SLE$tib.threshold
        if (length(SLE$output) > 0 & SLE$detection.failed == FALSE) {
          id = as.character(unlist(strsplit(I$filename,"_"))[1])
          datename = as.character(unlist(strsplit(as.character(as.matrix(M$metashort[1]))," "))[1])
          plottitle = " " #datename#"blablbalbal"# paste("File: ",i," | date: ",datename," | filename: ",fna2," | night: ",j,sep="")
          if (do.part3.pdf == TRUE) {
            pdf(paste(metadatadir,"/meta/sleep.qc/graphperday_id_",id,"_",I$filename,".pdf",sep=""),width=8.2,height=11.7)
            g.sib.plot(SLE,M,I,plottitle,nightsperpage=nightsperpage)
            dev.off()
          }
          sib.cla.sum = c()
          sib.cla.sum = g.sib.sum(SLE,M,ignorenonwear=ignorenonwear,desiredtz=desiredtz)
          save(sib.cla.sum,L5list,lightson,lightsout,tib.threshold,file=paste(metadatadir,"/meta/ms3.out/",fname,".RData",sep=""))
        }
      }
    }
  }
  SI = sessionInfo()
  
  save(SI,file=paste(metadatadir,"/results/QC/sessioninfo_part3.RData",sep=""))
}
