% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sdist.GFGM.BurrIII.R
\name{Sdist.GFGM.BurrIII}
\alias{Sdist.GFGM.BurrIII}
\title{Sub-distribution functions under the generalized FGM copula with the Burr III margins}
\usage{
Sdist.GFGM.BurrIII(time, Alpha, Beta, Gamma, p, q, theta, eta = 0)
}
\arguments{
\item{time}{Vector of times.}

\item{Alpha}{Positive shape parameter for the Burr III margin (failure cause 1).}

\item{Beta}{Positive shape parameter for the Burr III margin (failure cause 2).}

\item{Gamma}{Common positive shape parameter for the Burr III margins.}

\item{p}{Copula parameter that greater than or equal to 1.}

\item{q}{Copula parameter that greater than 1 (integer).}

\item{theta}{Copula parameter with restricted range.}

\item{eta}{Location parameter with default value 0.}
}
\value{
\item{time}{Failure times}
\item{Sdist.1}{Probability of an object fails due to the failure cause 1.}
\item{Sdist.2}{Probability of an object fails due to the failure cause 2.}
}
\description{
Sub-distribution functions under the generalized FGM copula with the Burr III margins.
}
\details{
The copula parameter \code{q} is restricted to be a integer due to the binominal theorem.
The admissible range of \code{theta} is given in \code{Dependence.GFGM}.
}
\examples{
library(GFGM.copula)
Sdist.GFGM.BurrIII(c(1:5),1,1,1,3,2,0.75,eta = 1)
}
\references{
Shih J-H, Emura T (2016) Bivariate dependence measures and bivariate competing risks models under the generalized FGM copula, Statistical Papers, doi: 10.1007/s00362-016-0865-5.

Shih J-H, Emura T (2018) Likelihood-based inference for bivariate latent failure time models with competing risks udner the generalized FGM copula, Computational Statistics, doi: 10.1007/s00180-018-0804-0.
}
\seealso{
\code{\link{MLE.GFGM.BurrIII}}, \code{\link{Dependence.GFGM}}
}
