% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelopes.r
\name{plot.combined_global_envelope}
\alias{plot.combined_global_envelope}
\title{Plot method for the class 'combined_global_envelope'}
\usage{
\method{plot}{combined_global_envelope}(
  x,
  labels,
  scales,
  sign.col = "red",
  ncol = 2 + 1 * (length(x) == 3),
  digits = 3,
  level = 1,
  ...
)
}
\arguments{
\item{x}{An 'combined_global_envelope' object}

\item{labels}{A character vector of suitable length.
If \code{dotplot = TRUE} (for the level 2 test), then labels for the tests at x-axis.
Otherwise labels for the separate plots.}

\item{scales}{See \code{\link[ggplot2]{facet_wrap}}.
Use \code{scales = "free"} when the scales of the functions in the global envelope
vary. \code{scales = "fixed"} is a good choice, when you want the same y-axis for all components.
A sensible default based on r-values exists.}

\item{sign.col}{The color for the observed curve when outside the global envelope
(significant regions). Default to "red". Setting the color to \code{NULL} corresponds
to no coloring. If the object contains several envelopes, the coloring is done for
the widest one.}

\item{ncol}{The maximum number of columns for the figures.
Default 2 or 3, if the length of x equals 3.
(Relates to the number of curve_sets that have been combined.)}

\item{digits}{The number of digits used for printing the p-value or p-interval
in the default main.}

\item{level}{1 or 2. In the case of two-step combined tests (with several test functions),
two different plots are available:
1 for plotting the combined global envelopes (default and most often wanted) or
2 for plotting the second level test result.}

\item{...}{Ignored.}
}
\description{
This function provides plots for combined global envelopes.
}
\details{
Plotting method for the class 'combined_global_envelope', i.e. combined envelopes for
1d functions.
}
\seealso{
\code{\link{central_region}}
}
