% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appl_indeptest.r
\name{GET.cdf}
\alias{GET.cdf}
\title{Test of independence based on cumulative distribution function}
\usage{
GET.cdf(X, ngrid = c(20, 20), nsim = 999, seq.x = NULL, seq.y = NULL, ...)
}
\arguments{
\item{X}{A matrix with n rows and 2 columns. Each row contains
one bivariate observation.}

\item{ngrid}{Vector with two elements, giving the number of grid
points to be used in the test statistic for each of the two marginals.
The default is 20 in each marginal.}

\item{nsim}{The number of random permutations used.}

\item{seq.x}{For the first marginal, the values at which the
empirical cumulative distribution function will be evaluated.
If NULL (the default), sequence of quantiles will be used,
equidistant in terms of probability.}

\item{seq.y}{For the second marginal, the values at which the
empirical cumulative distribution function will be evaluated.
If NULL (the default), sequence of quantiles will be used,
equidistant in terms of probability.}

\item{...}{Additional parameters to be passed to \code{\link{global_envelope_test}}.
In particularly, \code{alpha} specifies the nominal significance level of the test,
and \code{type} the type of the global envelope test.}
}
\description{
Permutation-based test of independence in a bivariate vector
using the empirical joint cumulative distribution function as
the test statistic.
}
\details{
Permutation-based test of independence in a bivariate sample,
based on empirical joint cumulative distribution function
computed on a grid of \code{ngrid[1]} times \code{ngrid[2]} arguments.
The grid points are chosen according to the quantiles of the
marginal distributions.

If the observed data are the pairs \eqn{\{(X_1, Y_1), \ldots, (X_n, Y_n)\}}{{(X_1, Y_1), ..., (X_n, Y_n)}},
the permutations are obtained by randomly permuting the values
in the second marginal, i.e. \eqn{\{(X_1, Y_{\pi(1)}), \ldots, (X_n, Y_{\pi(n)})\}}{{(X_1, Y_{pi(1)}), ..., (X_n, Y_{pi(n)})}}.

The test itself is performed using the global envelope test of the chosen version,
see the argument \code{type} of \code{\link{global_envelope_test}}.
}
\examples{
# Generate sample data
data <- matrix(rnorm(n=200), ncol=2) \%*\% matrix(c(1,1,0,1), ncol=2)
plot(data)

# Compute the CDF test and plot the significant regions
\donttest{res <- GET.cdf(data, ngrid=c(20,15), nsim=1999)}
\dontshow{res <- GET.cdf(data, ngrid=c(20,15), nsim=19)}
plot(res)

# Extract the p-value
attr(res,"p")
}
\references{
Dvořák, J. and Mrkvička, T. (2022). Graphical tests of independence for general distributions. Computational Statistics 37, 671--699.
}
