% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.r
\name{graph.fglm}
\alias{graph.fglm}
\title{Graphical functional GLM}
\usage{
graph.fglm(nsim, formula.full, formula.reduced, curve_sets,
  factors = NULL, summaryfun = c("means", "contrasts"),
  savefuns = FALSE, ..., GET.args = NULL, mc.cores = 1L,
  mc.args = NULL)
}
\arguments{
\item{nsim}{The number of random permutations.}

\item{formula.full}{The formula specifying the general linear model,
see \code{formula} in \code{\link[stats]{lm}}.}

\item{formula.reduced}{The formula of the reduced model with nuisance factors only.}

\item{curve_sets}{A named list of sets of curves giving the dependent variable (Y), and
possibly additionally all the factors. The dimensions of the elements should
match with each other, i.e. the factor values should be given for each argument value
and each function. If factors are given in the argument \code{factors}, then can also be just
the curve set representing Y. Also \code{\link[fda.usc]{fdata}} objects allowed.}

\item{factors}{A data frame of factors. An alternative way to specify factors when they
are constant for all argument values. The number of rows of the data frame should be equal
to the number of curves. Each column should specify the values of a factor.}

\item{summaryfun}{Possible values are "means" and "contrasts".
See description for their meaning.}

\item{savefuns}{Logical. If TRUE, then the functions from permutations are saved to the attribute
simfuns.}

\item{...}{Additional arguments to be passed to \code{\link[stats]{lm}}.}

\item{GET.args}{A named list of additional arguments to be passed to \code{\link{global_envelope_test}}.}

\item{mc.cores}{The number of cores to use, i.e. at most how many child processes will be run simultaneously.
Must be at least one, and parallelization requires at least two cores. On a Windows computer mc.cores must be 1
(no parallelization). For details, see \code{\link{mclapply}}, for which the argument is passed.
Parallelization can be used in generating simulations and in calculating the second stage tests.}

\item{mc.args}{A named list of additional arguments to be passed to \code{\link{mclapply}}.
Only relevant if \code{mc.cores} is more than 1.}
}
\value{
A \code{global_envelope} or \code{combined_global_envelope} object,
which can be printed and plotted directly.
}
\description{
Non-parametric graphical tests of significance in functional general linear model (GLM)
}
\details{
The function \code{graph.fglm} performs the graphical functional GLM of Mrkvička et al. (2019).
This is a nonparametric graphical test of significance of a covariate in functional GLM.
The test is able to find not only if the factor of interest is significant, but also which
functional domain is responsible for the potential rejection.
In the case of functional multi-way main effect ANOVA or functional main effect ANCOVA models,
the test is able to find which groups differ (and where they differ).
In the case of functional factorial ANOVA or functional factorial ANCOVA models,
the test is able to find which combination of levels (which interactions) differ (and where they differ).
The described tests are global envelope tests applied in the context of GLMs.
The Freedman-Lane algorithm (Freedman and Lane, 1983) is applied to permute the functions
(to obtain the simulations under the null hypothesis of "no effects");
consequently, the test approximately achieves the desired significance level.
}
\examples{
data(rimov)
\donttest{
res <- graph.fglm(nsim=19, # Increase the number of simulations for serious analysis!
                  formula.full = Y~Year,
                  formula.reduced = Y~1,
                  curve_sets = list(Y=rimov), factors = data.frame(Year = 1979:2014))
}
\dontshow{
res <- graph.fglm(nsim=3,
                  formula.full = Y~Year,
                  formula.reduced = Y~1,
                  curve_sets = list(Y=rimov), factors = data.frame(Year = 1979:2014),
                  GET.args = list(alpha=0.25))
}
plot(res)

\donttest{
data(GDPtax)
factors.df <- data.frame(Group = GDPtax$Group, Tax = GDPtax$Profittax)
res.tax_within_group <- graph.fglm(nsim = 999,
                                  formula.full = Y~Group+Tax+Group:Tax,
                                  formula.reduced = Y~Group+Tax,
                                  curve_sets = list(Y=GDPtax$GDP),
                                  factors = factors.df)
plot(res.tax_within_group)
}
}
\references{
Mrkvička, T., Roskovec, T. and Rost, M. (2019) A nonparametric graphical tests of significance in functional GLM. arXiv:1902.04926 [stat.ME]

Freedman, D., & Lane, D. (1983) A nonstochastic interpretation of reported significance levels. Journal of Business & Economic Statistics, 1(4), 292-298. doi:10.2307/1391660
}
