% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphfanova.r
\name{graph.fanova2d}
\alias{graph.fanova2d}
\title{One-way graphical functional ANOVA for images}
\usage{
graph.fanova2d(nsim, image_set, groups, ...)
}
\arguments{
\item{nsim}{The number of random permutations.}

\item{image_set}{A set of images containing the data, see \code{\link{create_image_set}}.}

\item{groups}{The original groups (a factor vector representing the assignment to groups).}

\item{...}{Additional parameters to be passed to \code{\link{graph.fanova}}.}
}
\value{
A \code{global_envelope2d} or \code{combined_global_envelope2d} object, which can be
printed and plotted directly.
}
\description{
One-way ANOVA tests for image data with graphical interpretation
}
\details{
This function can be used to perform one-way graphical functional ANOVA tests described
in Mrkvička et al. (2018). The function transforms images to vectors (1d), calls
\code{\link{graph.fanova}} and transform results back to images (2d).
}
\examples{
\donttest{
data("imageset1")
res <- graph.fanova2d(nsim = 19, # Increase nsim for serious analysis!
                      image_set = imageset1$image_set,
                      groups = imageset1$Group)
plot(res)
# Contrasts
res.c <- graph.fanova2d(nsim = 19, # Increase nsim for serious analysis!
                        image_set = imageset1$image_set,
                        groups = imageset1$Group,
                        summaryfun = "contrasts")
plot(res.c)
plot(res.c, contours=FALSE)
}
}
\references{
Mrkvička, T., Myllymäki, M., Jilek, M. and Hahn, U. (2018)
A one-way ANOVA test for functional data with graphical interpretation.
arXiv:1612.03608 [stat.ME] (http://arxiv.org/abs/1612.03608)
}
