% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.r
\name{GET.necdf}
\alias{GET.necdf}
\title{Graphical n sample test of correspondence of distribution functions}
\usage{
GET.necdf(x, r = seq(min(unlist((lapply(x, min)))), max(unlist((lapply(x,
  max)))), length = 100), summaryfun = c("means", "contrasts"), nsim,
  ...)
}
\arguments{
\item{x}{A list (of length n) of values in the n groups.}

\item{r}{The sequence of argument values at which the distribution functions are compared.
The default is 100 equally spaced values between the minimum and maximum over all groups.}

\item{summaryfun}{Possible values are "means" and "contrasts". See \code{\link{graph.fanova}} for more information.}

\item{nsim}{The number of random permutations.}

\item{...}{Additional parameters to be passed to \code{\link{global_envelope_test}}.}
}
\description{
Compare the distributions of two (or more) groups.
}
\details{
The default number of permutation, if nsim is not specified, is
n*1000 - 1 for the case \code{"means"} and (n*(n-1)/2)*1000 - 1 for the case \code{"contrasts"},
where n is the length of x.
}
\examples{
if(require(fda, quietly=TRUE)) {
  # Heights of boys and girls at age 10
  f.a <- growth$hgtf["10",] # girls at age 10
  m.a <- growth$hgtm["10",] # boys at age 10
  # Empirical cumulative distribution functions
  plot(ecdf(f.a))
  plot(ecdf(m.a), col=grey(0.7), add=TRUE)
  # Create a list of the data
  fm.list <- list(Girls=f.a, Boys=m.a)
  \donttest{
  res_m <- GET.necdf(fm.list, summaryfun="means")
  plot(res_m)
  res_c <- GET.necdf(fm.list, summaryfun="contrasts")
  plot(res_c)
  }
  \dontshow{
  # The test with lower number of simulations
  res_m <- GET.necdf(fm.list, summaryfun="means", nsim=4, alpha=0.2)
  plot(res_m)
  res_c <- GET.necdf(fm.list, summaryfun="contrasts", nsim=4, alpha=0.2)
  plot(res_c)
  }

  # Heights of boys and girls at age 14
  f.a <- growth$hgtf["14",] # girls at age 14
  m.a <- growth$hgtm["14",] # boys at age 14
  # Empirical cumulative distribution functions
  plot(ecdf(f.a))
  plot(ecdf(m.a), col=grey(0.7), add=TRUE)
  # Create a list of the data
  fm.list <- list(Girls=f.a, Boys=m.a)
  \donttest{
  res_m <- GET.necdf(fm.list, summaryfun="means")
  plot(res_m)
  res_c <- GET.necdf(fm.list, summaryfun="contrasts")
  plot(res_c)
  }
  \dontshow{
  # The test with lower number of simulations
  res_m <- GET.necdf(fm.list, summaryfun="means", nsim=4, alpha=0.2)
  plot(res_m)
  res_c <- GET.necdf(fm.list, summaryfun="contrasts", nsim=4, alpha=0.2)
  plot(res_c)
  }
}
}
