% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_networks.R
\name{simulate_networks}
\alias{simulate_networks}
\title{A Function to simulate networks from a GERGM with given theta parameters.}
\usage{
simulate_networks(formula, mutual = 0, ttriads = 0, ctriads = 0,
  in2stars = 0, out2stars = 0, twostars = 0,
  simulation_method = c("Metropolis", "Gibbs"),
  network_is_directed = c(TRUE, FALSE),
  number_of_networks_to_simulate = 500, thin = 1, proposal_variance = 0.1,
  downweight_statistics_together = TRUE, MCMC_burnin = 100, seed = 123,
  omit_intercept_term = FALSE, ...)
}
\arguments{
\item{formula}{A formula object that specifies which statistics the user would
like to include while simulating the network, and the network the user is
providing as the initial network. Currently, the following statistics can be
specified: c("out2stars", "in2stars",     "ctriads", "mutual", "ttriads").}

\item{mutual}{The theta value provided for the reciprocity parameter, defaults
to 0. Only statistics for structural terms included in formula will be used.}

\item{ttriads}{The theta value provided for the transitive triads parameter,
defaults to 0. Only statistics for structural terms included in formula will
be used.}

\item{ctriads}{The theta value provided for the cyclic triads parameter,
defaults to 0. Only statistics for structural terms included in formula will
be used.}

\item{in2stars}{The theta value provided for the in 2-stars parameter,
defaults to 0. Only statistics for structural terms included in formula will
be used.}

\item{out2stars}{The theta value provided for the out 2-starts parameter,
defaults to 0. Only statistics for structural terms included in formula will
be used.}

\item{twostars}{The theta value provided for the undirected 2-starts parameter,
defaults to 0. Only statistics for structural terms included in formula will
be used.}

\item{simulation_method}{Default is "Metropolis" which allows for exponential
downweighting, can also be "Gibbs".}

\item{network_is_directed}{Logical specifying whether or not the observed
network is directed. Default is TRUE.}

\item{number_of_networks_to_simulate}{Number of simulations generated for
estimation via MCMC. Default is 500.}

\item{thin}{The proportion of samples that are kept from each simulation. For
example, thin = 1/200 will keep every 200th network in the overall simulated
sample. Default is 1.}

\item{proposal_variance}{The variance specified for the Metropolis Hastings
simulation method. This parameter is inversely proportional to the average
acceptance rate of the M-H sampler and should be adjusted so that the average
acceptance rate is approximately 0.25. Default is 0.1.}

\item{downweight_statistics_together}{Logical specifying whether or not the
weights should be applied inside or outside the sum. Default is TRUE and user
should not select FALSE under normal circumstances.}

\item{MCMC_burnin}{Number of samples from the MCMC simulation procedure that
will be discarded before drawing the samples used for estimation. Default is
100.}

\item{seed}{Seed used for reproducibility. Default is 123.}

\item{omit_intercept_term}{Defualts to FALSE, can be set to TRUE if the user wishes to omit the model intercept term.}

\item{...}{Optional arguments, currently unsupported.}
}
\value{
A list object containing simulated networks and parameters used to
specify the simulation. See the $MCMC_Output field for simulated networks.
}
\description{
Simulates networks from a GERGM for a given set of parameter values.
}
\examples{
set.seed(12345)
net <- matrix(runif(100),10,10)
diag(net) <- 0
colnames(net) <- rownames(net) <- letters[1:10]
formula <- net ~ ttriads + in2stars

test <- simulate_networks(formula,
 ttriads = 0.6,
 in2stars = -0.8,
 network_is_directed = TRUE,
 simulation_method = "Metropolis",
 number_of_networks_to_simulate = 100,
 thin = 1/10,
 proposal_variance = 0.5,
 downweight_statistics_together = TRUE,
 MCMC_burnin = 1000,
 seed = 456)
}

