% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{plotSegmentEllipse}
\alias{plotSegmentEllipse}
\title{Plot an ellipse representation of a segment 'confidence interval'}
\usage{
plotSegmentEllipse(segmentationCSV, plotRows, projection = "aitoff",
  col = "red", singlePlot = TRUE, confidenceLevel = 0.05,
  alpha = thresholds, wrap = FALSE, greyGrid = FALSE)
}
\arguments{
\item{segmentationCSV}{The file path to the csv file created from the segmentation process containing all features.}

\item{plotRows}{The rows from the csv file to be used to simulate plotting data.}

\item{projection}{The type of projection to be used. Can be any of those used by \code{mapproject} in the package \code{mapproj}.}

\item{col}{A vector of character strings to indicate the colour of each ellipse. 
If the number of segments is greater than the length of the colours vector then colurs will be repeated.}

\item{singlePlot}{(logical) Indicates wether all rows should be added to one plot.}

\item{confidenceLevel}{The alpha value for the confidence interval. A value of 0.05 corresponds to a 95\% confidence interval.}

\item{alpha}{The alpha level to use for plotting colours.}

\item{wrap}{(logical) Indicating whether segments should be wrapped around the sphere or cropped. By default ellipses are cropped.}

\item{greyGrid}{(logical) Should the plot be created with a white background and grey grid or a grey background with white grid (default).}
}
\value{
There is no return to the console. As a side effect a graphic is created.
}
\description{
Create an ellipse representing a 'confidence interval' of a given segment and plot a projected representation.
}
\details{
This function uses the mean and standard deviation estimates for elevation and rotation of a segment to determine
a confidence interval for each direction. This is then used to generate an ellipse representing the two dimensional confidence region. 
This ellipse is plotted onto a projected representation of the sphere.
Required columns are:\enumerate{
    \item UpDown.median
    \item UpDown.mad
    \item Degrees.median
    \item Degrees.mad
}
}
\examples{
\dontrun{
segmentationCSV = system.file("data", "SegData.csv", package = "GENEAsphere")
plotRows = c(1:1)
plotSegmentEllipse(segmentationCSV, plotRows, projection = "aitoff", 
  col = "red", singlePlot = TRUE, confidenceLevel = 0.05, 
  alpha = thresholds, wrap = FALSE, greyGrid = FALSE)
 }
}
