% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGENEAsegments.R
\name{getGENEAsegments}
\alias{getGENEAsegments}
\title{import and segment one or more bin files.}
\usage{
getGENEAsegments(
  testfile,
  start = NULL,
  end = NULL,
  Use.Timestamps = FALSE,
  radians = FALSE,
  mmap.load = (.Machine$sizeof.pointer >= 8),
  outputtoken = "_segmented",
  outputdir = "GENEAclassification",
  datacols = "default",
  decimalplaces = "default",
  filterWave = FALSE,
  filtername = "haar",
  j = 8,
  changepoint = c("UpDownDegrees", "TempFreq", "UpDownFreq", "UpDownMean", "UpDownVar",
    "UpDownMeanVar", "DegreesMean", "DegreesVar", "DegreesMeanVar",
    "UpDownMeanVarDegreesMeanVar", "UpDownMeanVarMagMeanVar"),
  penalty = "Manual",
  pen.value1 = 40,
  pen.value2 = 400,
  intervalseconds = 30,
  mininterval = 5,
  samplefreq = 100,
  filterorder = 2,
  boundaries = c(0.5, 5),
  Rp = 3,
  plot.it = FALSE,
  hysteresis = 0.1,
  plot.seg = FALSE,
  plot.seg.outputfile = "Changepoint",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{testfile}{character vector stating path to a GENEActiv bin file, or a folder containing GENEActiv bin files.}

\item{start}{Where to start reading observations.}

\item{end}{Where to end reading observations.}

\item{Use.Timestamps}{To use timestamps as the start and end time values this has to be set to TRUE. (Default FALSE)}

\item{radians}{calculate degrees rotation in radians.}

\item{mmap.load}{Default is (.Machine$sizeof.pointer >= 8). see \code{\link[mmap]{mmap}} for more details}

\item{outputtoken}{single character string to be appended to the file name
for saving the segmenation output (default '_segmentated').}

\item{outputdir}{The absolute or relative path to directory in which artifacts (plot and changes files) should be created, or NULL
(default "GENEAclassification").}

\item{datacols}{a vector constructed 'column.summary' or 'default'. See \code{\link{segmentation}} for details.}

\item{decimalplaces}{named numeric vector of decimal places with which to
round summary columns. \code{NULL} returns unrounded values.
The length 1 character vector 'default' applies default roundings: \itemize{
    \item Start.Time = 0,
    \item Degrees.mean = 3,
    \item Degrees.median = 3,
    \item Degrees.var = 3,
    \item Degrees.sd = 3,
    \item Degrees.mad = 3,
    \item Magnitude.mean = 3,
    \item UpDown.mean = 3,
    \item UpDown.median = 3,
    \item UpDown.var = 3
    \item UpDown.sd = 3,
    \item UpDown.mad = 3,
    \item Principal.Frequency.median = 3,
    \item Principal.Frequency.mad = 3,
    \item Principal.Frequency.ratio = 3,
    \item Principal.Frequency.sumdiff = 3,
    \item Principal.Frequency.meandiff = 3,
    \item Principal.Frequency.abssumdiff = 3,
    \item Principal.Frequency.sddiff = 3,
    \item Light.mean = 0,
    \item Light.max = 0,
    \item Temp.mean = 1,
    \item Temp.sumdiff = 3
    \item Temp.meandiff = 3
    \item Temp.abssumdiff = 3
    \item Temp.sddiff = 3
    \item Step.count = 0
    \item Step.sd = 1
    \item Step.mean = 0
    \item Step.GENEAamplitude = 3
    \item Step.GENEAwavelength = 3
    \item Step.GENEAdistance = 3
}
This can be changed by using a named list. e.g decimalplaces = c(Start.Time = 2, Degrees.mean = 4).}

\item{filterWave}{single logical, should a smoothing filter from \code{\link[waveslim]{wave.filter}} be applied? (default FALSE).}

\item{filtername}{single character, the name of the wavelet to use for smoothing
when filter is TRUE. (default "haar") Passed to \code{link[waveslim]{wave.filter}}.}

\item{j}{single numeric, the level to which to smooth. Passed to \code{link[waveslim]{wave.filter}} (default 8).}

\item{changepoint}{defines the change point analysis to use. UpDownDegrees performs the change point analysis on the variance of arm elevation and wrist rotation. 
TempFreq performs a change point on the variance in the temeprature and frequency (Typically better for sleep behaviours).}

\item{penalty}{single characgter, the penalty to use for changepoint detection. default ("SIC").}

\item{pen.value1}{Value of the type 1 error required when penalty is "Asymptotic".}

\item{pen.value2}{Default set as NULL and so equals pen.value1 if no input.}

\item{intervalseconds}{An integer number of seconds between 5 and 30 during which at most one changepoint may occur.}

\item{mininterval}{single numeric that defines the smallest changepoint initially found. Passed to \code{\link[changepoint]{cpt.var}} as the variable minseglen}

\item{samplefreq}{The sampling frequency of the data, in hertz,
when calculating the step number. (default 100).}

\item{filterorder}{The order of the filter applied with respect to the butter or cheby options. 
See \code{\link[signal]{cheby1}} or \code{\link[signal]{butter}}.}

\item{boundaries}{to pass to the filter in the step counting algorithm.}

\item{Rp}{the decibel level that the cheby filter takes. See \code{\link[signal]{cheby1}}.}

\item{plot.it}{single logical, Creates a plot showing the zero crossings counted by the step counting algorithm#' @param Centre Centres the xz signal about 0 when set to True.}

\item{hysteresis}{The hysteresis applied after zero crossing. (default 100mg)}

\item{plot.seg}{single logical, Creates a plot displaying the changepoint locations.}

\item{plot.seg.outputfile}{The name of the png file created that shows the change points on a positionals plots.}

\item{verbose}{single logical should additional progress reporting be printed at the console? (default TRUE).}

\item{...}{other arguments to be passed to \code{\link{dataImport}},
\code{\link{segmentation}} and other functions with these functions.}
}
\value{
segmented data are returned
}
\description{
Import and summarize GENEActiv bin data for manual classification.
}
\examples{
## testfile = file.path(system.file(package = "GENEAread"),
##                                  "binfile",
##                                  "TESTfile.bin")
## 
## segData <- getGENEAsegments(testfile = testfile,
##                             outputdir = file.path(tempdir(), "GENEAclassification"),    
##                             changepoint = "UpDownDegrees",
##                             pen.value1 = 1,
##                             pen.value2 = 1)
## head(segData)
## list.files(file.path(tempdir(), "GENEAclassification"))
}
\seealso{
The returned object can be interrogated with \code{\link[=head.GENEAbin]{head}}.
}
