% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QPCorr.pval.R
\name{QPCorr.pval}
\alias{QPCorr.pval}
\title{P-values of the "QPCorr.matrix" obtained using a permutation approach}
\usage{
QPCorr.pval(
  G,
  E,
  Y,
  tau,
  w = NULL,
  permutation_t = 1000,
  family = c("continuous", "survival")
)
}
\arguments{
\item{G}{Input matrix of \code{p} genetic (G) measurements consisting of \code{n} rows. Each row is an observation vector.}

\item{E}{Input matrix of \code{q} environmental (E) risk factors, each row is an observation
vector.}

\item{Y}{Response variable. A quantitative vector for \code{family="continuous"}. For
\code{family="survival"}, \code{Y} should be a two-column matrix with the first column being
the log(survival time) and the second column being the censoring indicator. The indicator is a
binary variable, with "1" indicating dead, and "0" indicating right censored.}

\item{tau}{Quantile.}

\item{w}{Weight for accommodating censoring if \code{family="survival"}. Default is NULL and a
Kaplan-Meier estimator-based weight is used.}

\item{permutation_t}{Permutation times.}

\item{family}{Response type of \code{Y} (see above).}
}
\value{
Matrix of p-value, with the element in the \code{i}th row and the \code{j} column
represents the p-value of the (censored) quantile partial correlation corresponding to the
\code{i}th E and the \code{j}th G.
}
\description{
P-values of the \code{"QPCorr.matrix "} obtained using a permutation approach, the
interactions with smaller p-values are regarded as more important.
}
\examples{
n=50
alpha=matrix(0,5,1)
alpha[1:2]=1
beta=matrix(0,6,20)
beta[1,1:4]=1
beta[2:3,1:4]=2
sigmaG<-AR(rho=0.3,20)
sigmaE<-AR(rho=0.3,5)
G<-MASS::mvrnorm(n,rep(0,20),sigmaG)
E<-MASS::mvrnorm(n,rep(0,5),sigmaE)
e1<-rnorm(n*.05,50,1);e2<-rnorm(n*.05,-50,1);e3<-rnorm((n-length(e1)-length(e2)))
e<-c(e1,e2,e3)

\donttest{
# continuous
y1=simulated_data(G=G,E=E,alpha=alpha,beta=beta,error=e,family="continuous")
cpqcorr_pvalue1<-QPCorr.pval(G,E,y1,tau=0.5,permutation_t=500,family="continuous")

# survival
y2=simulated_data(G,E,alpha,beta,rnorm(n,0,1),family="survival",0.7,0.9)
cpqcorr_pvalue2<-QPCorr.pval(G,E,y2,tau=0.5,permutation_t=500,family="survival")
}
}
\references{
Yaqing Xu, Mengyun Wu, Qingzhao Zhang, and Shuangge Ma.
\emph{Robust identification of gene-environment interactions for prognosis using a quantile
partial correlation approach. Genomics, 111(5):1115-1123, 2019.}
}
\seealso{
\code{QPCorr.matrix } method.
}
