% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StepIII_stepwise.R
\name{StepIII_stepwise}
\alias{StepIII_stepwise}
\title{Step III: Stepwise on the consolidated output from different GDS runs}
\source{
Singh, R. and Stufken, J. (2022). Factor selection in screening experiments
by aggregation over random models, 1--31. \doi{10.48550/arXiv.2205.13497}
}
\usage{
StepIII_stepwise(
  xstart,
  xremain,
  Xmain,
  Xint,
  Y,
  cri.penter = 0.01,
  cri.premove = 0.05,
  opt.heredity = "none"
)
}
\arguments{
\item{xstart}{a vector with effects' names corresponding to the starting model.}

\item{xremain}{a vector with effects' names corresponding to the remaining
main effects and other effects that needs to be explored with stepwise regression.}

\item{Xmain}{a \eqn{n \times m}{n x m} matrix of \code{m} main effects.}

\item{Xint}{a matrix of \code{m choose 2} two-factor
interactions.}

\item{Y}{a vector of \code{n} responses.}

\item{cri.penter}{the p-value cutoff for an effect to enter into the
stepwise regression model}

\item{cri.premove}{the p-value cutoff for an effect to exit from the
stepwise regression model}

\item{opt.heredity}{a string with either \code{none}, or \code{weak}, or \code{strong}. Denotes
whether the effect-heredity (weak or strong) should be embedded in GDS-ARM.
The default value is \code{none} as suggested in Singh and Stufken (2022).}
}
\value{
A list returning the effects identified as active as well as the
corresponding identified important factors.
}
\description{
Runs the stepwise regression on the output received from
top models of the consolidated output of different GDS runs. With
\code{n} being the number of runs, the stepwise regression starts
with at most \code{(n-3)} selected effects from the previous step. The
remaining effects from the previous step as well as all main effects are
given a chance to enter into the model using the forward-backward stepwise
regression.
}
\keyword{internal}
