% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CR.R
\name{ClassRate}
\alias{ClassRate}
\title{Classification Rate Evaluation}
\usage{
ClassRate(att1, att2)
}
\arguments{
\item{att1}{a matrix or data frame of attribute profiles}

\item{att2}{a matrix or data frame of attribute profiles}
}
\value{
a list with the following components:
 \describe{
\item{PCA}{the proportion of correctly classified attributes (i.e., attribute level classification rate)}
\item{PCV}{a vector giving the proportions of correctly classified attribute vectors (i.e., vector level classification rate).
                  The fist element is the proportion of at least one attribute in the vector are correctly identified; the second
                  element is the proportion of at least two attributes in the vector are correctly identified; and so forth. The last
                  element is the proportion of all elements in the vector are correctly identified.}
}
}
\description{
This function evaluates the classification rates for two sets of attribute profiles
}
\examples{
\dontrun{
N <- 2000
# ---- Simulated G-DINA model ----- #

# using probability of success in matrix format ---- #
# model does not matter if item parameter is probability of success
Q <- sim30GDINA$simQ
J <- nrow(Q)
gs <- matrix(0.1,J,2)

set.seed(12345)
sim <- simGDINA(N,Q,gs.parm = gs)
GDINA.est <- GDINA(sim$dat,Q)

CR <- ClassRate(sim$attribute,personparm(GDINA.est))
CR
}
}
