% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetVis.R
\name{NetVis}
\alias{NetVis}
\title{Create a dynamic network representing the relationship between two groups of variables}
\usage{
NetVis(
  data,
  g1,
  g2,
  col1 = "aquamarine",
  col2 = "red",
  edge_col = "gray",
  remove_label = NULL,
  node_size = c(15, 40),
  font_size = 45,
  edge_width = 1
)
}
\arguments{
\item{data}{A data frame containing the relationship between the two groups to be represented in the network}

\item{g1}{Name of the column containing the labels of the first group that will be used to create the network}

\item{g2}{Name of the column containing the labels of the second group that will be used to create the network}

\item{col1}{Color of the nodes that will represent the first group represented in the network. The default value is aquamarine}

\item{col2}{Color of the nodes that will represent the second group represented in the network The default value is red}

\item{edge_col}{Color of the edges that will connect the nodes in the network. The default value is gray}

\item{remove_label}{If is required to omit the labels for some of the groups, this argument receives the column name informed  the g1 or g2 arguments. The default value is NULL}

\item{node_size}{A vector with the node sizes to represent g1 and g2. The defaul values are 15 and 40, respectively}

\item{font_size}{The size of the font of the labels of each node (The default value is 45)}

\item{edge_width}{The width of the edges connecting the nodes in the network}
}
\value{
A dynamic network representing the connection between two groups.
}
\description{
Create a dynamic network representing the relationship between two groups of variables
}
\details{
This function returns a dynamic network, using visNetwork, representing the connection between two groups. For example, the output from the find_genes_qtls_around_markers() function can be used here to represent the connections between markers and QTLs. Another option is to combine the data frames with both gene and QTL annotation around markers to reprsent the connections between genes and QTLs.
}
