% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_weight.R
\name{fs_weight}
\alias{fs_weight}
\title{Fuzzy supplementary poverty estimation}
\usage{
fs_weight(dimensions, step2, rho = NULL)
}
\arguments{
\item{dimensions}{A numeric vector (of length  \code{ncol(data)}) of assignments of items in data to dimensions.}

\item{step2}{The data frame resulting from step2.}

\item{rho}{The critical value to be used for calculation of weights in the kendall correlation matrix.}
}
\value{
A data frame of weights and deprivation scores in each dimension identified.
}
\description{
Step 4 and Step 5. Calculates the weights of dimensions discovered after factor analysis.
}
\details{
This function calculates the two set of weights w_a and w_b (see References)
}
\examples{
data(eusilc)
step2 = fs_transform(eusilc[,4:23], weight = eusilc$DB090, ID = eusilc$ID)
dimensions = c(1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5)
steps4_5 = fs_weight(dimensions, step2 = step2, rho = NULL)
}
\references{
Betti, G., Gagliardi, F., & Verma, V. (2018). Simplified Jackknife variance estimates for fuzzy measures of multidimensional poverty. International Statistical Review, 86(1), 68-86.
}
