% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyVIKOR.R
\name{FuzzyVIKOR}
\alias{FuzzyVIKOR}
\title{Implementation of Fuzzy VIKOR Method for Multi-Criteria Decision Making Problems.}
\usage{
FuzzyVIKOR(decision, weights, cb, v)
}
\arguments{
\item{decision}{The decision matrix (\emph{m} x (\emph{n}*3)) with the values of the \emph{m} alternatives, for the \emph{n} criteria, and multiplied by 3 since they are triangular fuzzy numbers.}

\item{weights}{A vector of length \emph{n}*3, containing the fuzzy weights for the criteria.}

\item{cb}{A vector of length \emph{n}. Each component is either \code{cb(i)='max'} if the \emph{i-th} criterion is benefit or \code{cb(i)='min'} if the \emph{i-th} criterion is a cost.}

\item{v}{A value in [0,1]. It is used in the calculation of the Q index.}
}
\value{
\code{FuzzyVIKOR} returns a data frame which contains the score of the S, R and Q indixes and the ranking of the alternatives according to Q index.
}
\description{
The \code{FuzzyVIKOR} function implements the Fuzzy "VIseKriterijumska Optimizacija I Kompromisno Resenje" (Fuzzy VIKOR) Method.
}
\examples{

 d <- matrix(c(38,20,24.58,44.54,33.33,33.86,40.01,21.06,25.87,46.89,33.33,33.86,48,24,
 29.75,56.27,43.33,42.32,3.26,2.57,2.82,2.46,2.25,2.47,4.08,2.87,2.97,2.73,2.5,2.74,4.08,
 2.87,2.97,2.73,2.62,2.85,43,6,38,60,6,6,47,6,42,62,6,6,48,6,50,68,6,6,10,10,1,0,2,3,10,
 10,1,0,2,3,10,10,1,0,2,3),nrow=6,ncol=12)
 w <- c(1/12,1/12,1/12,1/12,1/12,1/12,1/12,1/12,1/12,1/12,1/12,1/12)
 cb <- c('min','max','min','min')
 v <- 0.625
 FuzzyVIKOR(d,w,cb,v)
}
\references{
Opricovic, S. Fuzzy VIKOR with an application to water resources planning. Expert Systems with Applications, 38(10), 12983-12990, 2011.
}

