% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frechetpc.R
\name{rf_shape_para}
\alias{rf_shape_para}
\title{Parallelized Frechet random forest}
\usage{
rf_shape_para(X, Y, id, time, mtry, ntree, ncores, timeScale = 0.1,
  ERT = FALSE, ...)
}
\arguments{
\item{X}{[matrix]: Matrix of explanatory variables, each column codes for a variable}

\item{Y}{[vector]: Output curves}

\item{id}{[vector]: IDs of measurements}

\item{time}{[vector]: time of measurements}

\item{mtry}{[numeric]: number of variables randomly chosen at each split}

\item{ntree}{[numeric]: number of randomized Frechet trees composing the Frechet random forest}

\item{ncores}{[numeric]: number of cores used in parallel}

\item{timeScale}{[numeric]: allow to modify the time scale, increasing or decreasing the cost of the horizontal shift. If timeScale is very big, then the Frechet mean tends to the Euclidean distance. If timeScale is very small, then it tends to the Dynamic Time Warping.}

\item{ERT}{[boolean]: if TRUE uses Extremly randomized Frechet trees to build the Frechet forest}

\item{...}{:}
}
\description{
A parallelized version of "rf_Shape" function
}
\keyword{internal}
