% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/height_crown_base_silva.R
\name{height_crown_base_silva_core}
\alias{height_crown_base_silva_core}
\title{Core function for the silva tree height to crown base calculation}
\usage{
height_crown_base_silva_core(species_id, dbh_cm, height_m)
}
\arguments{
\item{species_id}{Vector of species ids
(see \code{\link{height_crown_base_silva}}), but for this core function to
work, \code{species_id} must be provided as \code{character}. This will and
should be not checked inside this function, because if used as intended, that
has happened before calling it.}

\item{dbh_cm}{Vector of breast height diameters
(see \code{\link{height_crown_base_silva}})}

\item{height_m}{Vector of tree heights
(see \code{\link{height_crown_base_silva}})}
}
\value{
Tree height to crown base (see \code{\link{height_crown_base_silva}})
}
\description{
See documentation of \code{\link{height_crown_base_silva}} for most
information, this function is the workhorse behind, and should never be
called directly by a user.
}
\details{
The function \code{height_crown_base_silva} is fully vectorized, inputs are
recycled according to the tibble rules
}
\keyword{internal}
