% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_index.R
\name{score_index}
\alias{score_index}
\title{Measuring accuracy in a rolling forecast experiment}
\usage{
score_index(recf, base, test, m, nb, nl, type = "mse", compact = TRUE)
}
\arguments{
\item{recf}{list of q (forecast origins) reconciled forecasts' matrices
(\mjseqn{[n \times h(k^\ast + m)]} in the cross-temporal case,
\mjseqn{[h \times n]} in the cross-sectional case, and vectors of length
\mjseqn{[h(k^\ast \times m)]} in the temporal framework).}

\item{base}{list of q (forecast origins) base forecasts' matrices
(\mjseqn{[n \times h(k^\ast + m)]} in the cross-temporal case,
\mjseqn{[h \times n]} in the cross-sectional case, and vectors of length
\mjseqn{[h(k^\ast \times m)]} in the temporal framework).}

\item{test}{list of q (forecast origins) test observations' matrices
(\mjseqn{[n \times h(k^\ast + m)]} in the cross-temporal case,
\mjseqn{[h \times n]} in the cross-sectional case, and vectors of length
\mjseqn{[h(k^\ast \times m)]} in the temporal framework).}

\item{m}{Highest available sampling frequency per seasonal cycle (max. order
of temporal aggregation, \mjseqn{m}), or a subset of \mjseqn{p} factors
of \mjseqn{m}.}

\item{nb}{number of bottom time series in the cross-sectional framework.}

\item{nl}{(\mjseqn{L \times 1}) vector containing the number of time series
in each cross-sectional level of the hierarchy (\code{nl[1] = 1}).}

\item{type}{type of accuracy measure ("\code{mse}" Mean Square Error,
"\code{rmse}" Root Mean Square Error or "\code{mae}" Mean Absolute Error).}

\item{compact}{if TRUE returns only the summary matrix.}
}
\value{
It returns a summary table called \code{Avg_mat} (if \code{compact} option is \code{TRUE},
\emph{default}), otherwise it returns a list of six tables (more in
\href{https://danigiro.github.io/FoReco/articles/accuracy_indices.html}{Average relative accuracy indices}).
}
\description{
\loadmathjax
Function to calculate the accuracy indices of the reconciled point
forecasts of a cross-temporal (not only, see examples) system (more in
\href{https://danigiro.github.io/FoReco/articles/accuracy_indices.html}{Average relative accuracy indices}).
(\emph{Experimental version})
}
\examples{
\donttest{
data(FoReco_data)

# Cross-temporal framework
oct_recf <- octrec(FoReco_data$base, m = 12, C = FoReco_data$C,
                   comb = "bdshr", res = FoReco_data$res)$recf
oct_score <- score_index(recf = oct_recf,
                         base = FoReco_data$base,
                         test = FoReco_data$test, m = 12, nb = 5)

# Cross-sectional framework
# monthly base forecasts
id <- which(simplify2array(strsplit(colnames(FoReco_data$base), split = "_"))[1, ] == "k1")
mbase <- t(FoReco_data$base[, id])
# monthly test set
mtest <- t(FoReco_data$test[, id])
# monthly residuals
id <- which(simplify2array(strsplit(colnames(FoReco_data$res), split = "_"))[1, ] == "k1")
mres <- t(FoReco_data$res[, id])
# monthly reconciled forecasts
mrecf <- htsrec(mbase, C = FoReco_data$C, comb = "shr", res = mres)$recf
# score
hts_score <- score_index(recf = mrecf, base = mbase, test = mtest, nb = 5)

# Temporal framework
# top ts base forecasts ([lowest_freq' ...  highest_freq']')
topbase <- FoReco_data$base[1, ]
# top ts residuals ([lowest_freq' ...  highest_freq']')
topres <- FoReco_data$res[1, ]
# top ts test ([lowest_freq' ...  highest_freq']')
toptest <- FoReco_data$test[1, ]
# top ts recf ([lowest_freq' ...  highest_freq']')
toprecf <- thfrec(topbase, m = 12, comb = "acov", res = topres)$recf
# score
thf_score <- score_index(recf = toprecf, base = topbase, test = toptest, m = 12)
}

}
\references{
Di Fonzo, T., Girolimetto, D. (2020), Cross-Temporal Forecast Reconciliation:
Optimal Combination Method and Heuristic Alternatives, Department of Statistical
Sciences, University of Padua, \href{https://arxiv.org/abs/2006.08570}{arXiv:2006.08570}.
}
\seealso{
Other utilities: 
\code{\link{Cmatrix}()},
\code{\link{FoReco2ts}()},
\code{\link{commat}()},
\code{\link{ctf_tools}()},
\code{\link{hts_tools}()},
\code{\link{oct_bounds}()},
\code{\link{shrink_estim}()},
\code{\link{thf_tools}()}
}
\concept{utilities}
\keyword{utilities}
