# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Internal C function (do not use). 
#' 
#' Estimate parameters with MCEM algorithm
#' 
#' @param migration A migration (migration structure).
#' @param estimate_transitions Boolean for requiring transition parameters estimation.
#' @param estimate_sojourns Boolean for requiring sojourn parameters estimation.
#' @param sojourn_domain Sojourn parameters domains.
#' @param start_transitions Start transition.
#' @param start_sojourns Start sojourns.
#' @param nb_particles Number of particles.
#' @param itermax Maximum number of iteration.
#' @param MC_algo Monte Carlo algorithm name.
#' @param MH_neighborhood Neighborhood, only when MC_algo is "MH".
#' @param MH_transition_length Transition length, only when MC_algo is "MH".
#' @param log_transitions Log of transition parameters.
#' @param log_sojourns Log of sojourn parameters.
#' @param log_loglikelihood log of log-likelihood.
#' @param log_sel_particles log of selected particles.
#' @param log_acceptance_rate log of acceptance rate.
#' @param verbose Boolean for verbose.
#' 
#' @return migration with estimated parameters (migration structure).
#' 
#' @export
estimate_migration_MCEM_C <- function(migration, estimate_transitions = NULL, estimate_sojourns = NULL, sojourn_domain = NULL, start_transitions = NULL, start_sojourns = NULL, nb_particles = NULL, itermax = NULL, MC_algo = NULL, MH_neighborhood = NULL, MH_transition_length = NULL, log_transitions = NULL, log_sojourns = NULL, log_loglikelihood = NULL, log_sel_particles = NULL, log_acceptance_rate = NULL, verbose = NULL) {
    .Call('_FlywayNet_estimate_migration_MCEM_C', PACKAGE = 'FlywayNet', migration, estimate_transitions, estimate_sojourns, sojourn_domain, start_transitions, start_sojourns, nb_particles, itermax, MC_algo, MH_neighborhood, MH_transition_length, log_transitions, log_sojourns, log_loglikelihood, log_sel_particles, log_acceptance_rate, verbose)
}

#' Internal C function (do not use). 
#' 
#' Estimate parameters from a set of trajectories 
#' 
#' @param migration A migration (migration structure).
#' @param trajectories Set of trajectories (trajectory structure).
#' @param estimate_transitions Boolean for requiring transition parameters estimation.
#' @param estimate_sojourns Boolean for requiring sojourn parameters estimation.
#' @param sojourn_domain Sojourn parameters domains.
#' @param min_prob Minimum probability.
#' 
#' @return migration with estimated parameters (migration structure).
#' 
#' @export
estimate_migration_from_trajectories_C <- function(migration, trajectories, estimate_transitions = NULL, estimate_sojourns = NULL, sojourn_domain = NULL, min_prob = NULL) {
    .Call('_FlywayNet_estimate_migration_from_trajectories_C', PACKAGE = 'FlywayNet', migration, trajectories, estimate_transitions, estimate_sojourns, sojourn_domain, min_prob)
}

#' Internal C function (do not use). 
#' 
#' Simulates trajectories of individual birds.
#' 
#' @param migration A migration (migration structure).
#' @param trajectory Set of trajectories partially simulated (trajectory structure).
#'                   Default simulated until time step 1 (initial state of each bird).
#' @param end_time Time of the end of simulation. Default is the horizon (last time step).
#' 
#' @return the simulated trajectories
#' 
#' @export
generate_trajectories_C <- function(migration, trajectory = NULL, end_time = NULL) {
    .Call('_FlywayNet_generate_trajectories_C', PACKAGE = 'FlywayNet', migration, trajectory, end_time)
}

#' Internal C function (do not use). 
#' 
#' Counts birds on each state for every time step.
#' 
#' @param migration A migration (migration structure).
#' @param trajs Set of trajectories (trajectory matrix).
#' 
#' @return counts (count matrix).
#'
#' @export
get_counts_C <- function(migration, trajs) {
    .Call('_FlywayNet_get_counts_C', PACKAGE = 'FlywayNet', migration, trajs)
}

#' Internal C function (do not use). 
#' 
#' Computes the probability of observations given the birds count from 
#' trajectories : P(O | Pi_[0:T])
#' 
#' @param obs Observations. Matrix of I+2 rows and T+1 columns with observed 
#'   bird counts. I is the numbers of sites, to which one adds the virtual 
#'   sites 'death' and 'flight' and T is the horizon of the migration. 
#'   structure.
#' @param hidden_count Hidden counts. Matrix of I+2 rows and T+1 columns with 
#'   simulated bird counts. As computed by function get_count. 
#' @param use_log Boolean that states if the log probability should be returned.
#' 
#' @return the probability (or log-probability) of the observed data given 
#'   simulated counts.
#'   
#' @export
get_observation_probability_C <- function(obs, hidden_count, use_log) {
    .Call('_FlywayNet_get_observation_probability_C', PACKAGE = 'FlywayNet', obs, hidden_count, use_log)
}

