% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{random_Signu}
\alias{random_Signu}
\title{Randomly generate an innovation covariance matrix \eqn{\Sigma_{\boldsymbol{\nu}}}}
\usage{
random_Signu(p, num_nonzero)
}
\arguments{
\item{p}{Integer. Dimension of the covariance matrix (\eqn{p} variables).}

\item{num_nonzero}{Integer. Target number of nonzero off-diagonal entries
(counted individually; both upper and lower triangles are included).
Since nonzero values are inserted in symmetric pairs, an even value is
recommended. The maximum meaningful value is \eqn{p(p-1)}.}
}
\value{
A numeric symmetric matrix of dimension \eqn{p \times p} representing
\eqn{\Sigma_{\boldsymbol{\nu}}} with diagonal 0.5 and approximately
`num_nonzero` nonzero off-diagonal entries.
}
\description{
Generates a symmetric \eqn{p \times p} innovation covariance matrix
\eqn{\Sigma_{\boldsymbol{\nu}}} for the VAR(1) component in the proposed
model. The diagonal elements are fixed at 0.5, and a specified number of
off-diagonal elements are randomly assigned nonzero values to introduce
cross-correlation between variables.
}
\details{
Each nonzero off-diagonal entry is placed in symmetric pairs
\eqn{(i,j)} and \eqn{(j,i)} to ensure symmetry of the matrix. The magnitudes
of the nonzero entries are randomly drawn from the set
\eqn{\{0.1, 0.2\}} with randomly assigned signs. The diagonal entries are
fixed at 0.5 to maintain a moderate level of innovation variance.

In the full model, \eqn{\Sigma_{\boldsymbol{\nu}}} governs the variability
of the VAR(1) innovation term \eqn{\boldsymbol{\nu}_t} in
\eqn{\boldsymbol{\epsilon}_t = \Phi \boldsymbol{\epsilon}_{t-1} + \boldsymbol{\nu}_t}.
}
