% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf.seas.R
\name{bf.seas}
\alias{bf.seas}
\title{Seasonal baseflow percentage}
\usage{
bf.seas(TS, seas = c(6:8))
}
\arguments{
\item{TS}{data.frame of streamflow time series loaded with \code{\link{read.flows}}.}

\item{seas}{Integers representing months of the year. Default is c(6:8), i.e. June-August.}
}
\value{
Returns a vector containing the calculated percentage for each year
  in the input time series.  The "times" attribute provides the corresponding
  year for each calculated value.
}
\description{
This function estimates the percentage of baseflow in a given period relative to the total
annual baseflow.
}
\details{
This function calls \code{\link{bf_eckhardt}} to complete the 
  baseflow separation.
}
\examples{
data(cania.sub.ts)
cania.sub.ts <- set.plot.titles(cania.sub.ts, title.elements = c("StationID", "Country"))
res <- bf.seas(cania.sub.ts)
res2 <- screen.metric(res, "Percent Annual Baseflow in Jun-Aug", title = TRUE)
}
\seealso{
See \code{\link{bf.stats}} to calculate additional baseflow metrics.
}
\author{
Jennifer Dierauer
}
