// Generated by rstantools.  Do not edit by hand.

/*
    FlexReg is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    FlexReg is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with FlexReg.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_Beta0_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 17, column 1 to column 16)",
                                                      " (in 'string', line 18, column 1 to column 19)",
                                                      " (in 'string', line 19, column 1 to column 19)",
                                                      " (in 'string', line 22, column 1 to column 32)",
                                                      " (in 'string', line 23, column 1 to column 22)",
                                                      " (in 'string', line 24, column 1 to column 22)",
                                                      " (in 'string', line 25, column 1 to column 32)",
                                                      " (in 'string', line 26, column 1 to column 28)",
                                                      " (in 'string', line 35, column 2 to column 27)",
                                                      " (in 'string', line 34, column 6 to line 35, column 27)",
                                                      " (in 'string', line 33, column 2 to column 29)",
                                                      " (in 'string', line 32, column 6 to line 35, column 27)",
                                                      " (in 'string', line 31, column 2 to column 21)",
                                                      " (in 'string', line 30, column 6 to line 35, column 27)",
                                                      " (in 'string', line 29, column 2 to column 27)",
                                                      " (in 'string', line 28, column 1 to line 35, column 27)",
                                                      " (in 'string', line 37, column 2 to column 23)",
                                                      " (in 'string', line 38, column 2 to column 19)",
                                                      " (in 'string', line 36, column 15 to line 39, column 2)",
                                                      " (in 'string', line 36, column 1 to line 39, column 2)",
                                                      " (in 'string', line 68, column 1 to column 19)",
                                                      " (in 'string', line 73, column 2 to column 56)",
                                                      " (in 'string', line 71, column 2 to column 25)",
                                                      " (in 'string', line 70, column 0 to line 73, column 56)",
                                                      " (in 'string', line 69, column 14 to line 74, column 2)",
                                                      " (in 'string', line 69, column 1 to line 74, column 2)",
                                                      " (in 'string', line 46, column 1 to column 30)",
                                                      " (in 'string', line 45, column 6 to line 46, column 30)",
                                                      " (in 'string', line 44, column 1 to column 34)",
                                                      " (in 'string', line 43, column 1 to line 46, column 30)",
                                                      " (in 'string', line 51, column 2 to column 39)",
                                                      " (in 'string', line 50, column 6 to line 51, column 39)",
                                                      " (in 'string', line 49, column 2 to column 39)",
                                                      " (in 'string', line 48, column 1 to line 51, column 39)",
                                                      " (in 'string', line 47, column 16 to line 52, column 2)",
                                                      " (in 'string', line 47, column 1 to line 52, column 2)",
                                                      " (in 'string', line 57, column 2 to column 43)",
                                                      " (in 'string', line 56, column 6 to line 57, column 43)",
                                                      " (in 'string', line 55, column 2 to column 43)",
                                                      " (in 'string', line 54, column 1 to line 57, column 43)",
                                                      " (in 'string', line 53, column 17 to line 58, column 2)",
                                                      " (in 'string', line 53, column 1 to line 58, column 2)",
                                                      " (in 'string', line 64, column 1 to column 52)",
                                                      " (in 'string', line 62, column 2 to column 23)",
                                                      " (in 'string', line 61, column 1 to line 64, column 52)",
                                                      " (in 'string', line 60, column 14 to line 65, column 1)",
                                                      " (in 'string', line 60, column 1 to line 65, column 1)",
                                                      " (in 'string', line 2, column 1 to column 16)",
                                                      " (in 'string', line 3, column 8 to column 9)",
                                                      " (in 'string', line 3, column 1 to column 16)",
                                                      " (in 'string', line 4, column 1 to column 16)",
                                                      " (in 'string', line 5, column 1 to column 17)",
                                                      " (in 'string', line 6, column 8 to column 9)",
                                                      " (in 'string', line 6, column 10 to column 11)",
                                                      " (in 'string', line 6, column 1 to column 18)",
                                                      " (in 'string', line 7, column 8 to column 9)",
                                                      " (in 'string', line 7, column 10 to column 12)",
                                                      " (in 'string', line 7, column 1 to column 20)",
                                                      " (in 'string', line 8, column 1 to column 27)",
                                                      " (in 'string', line 9, column 1 to column 30)",
                                                      " (in 'string', line 10, column 1 to column 32)",
                                                      " (in 'string', line 11, column 1 to column 22)",
                                                      " (in 'string', line 12, column 1 to column 24)",
                                                      " (in 'string', line 13, column 1 to column 29)",
                                                      " (in 'string', line 14, column 1 to column 25)",
                                                      " (in 'string', line 17, column 8 to column 9)",
                                                      " (in 'string', line 18, column 8 to column 10)",
                                                      " (in 'string', line 22, column 25 to column 26)",
                                                      " (in 'string', line 23, column 17 to column 18)",
                                                      " (in 'string', line 24, column 17 to column 18)",
                                                      " (in 'string', line 25, column 26 to column 27)",
                                                      " (in 'string', line 68, column 8 to column 9)"};
#include <stan_meta_header.hpp>
class model_Beta0 final : public model_base_crtp<model_Beta0> {
private:
  int N;
  Eigen::Matrix<double, -1, 1> y;
  int K;
  int K0;
  Eigen::Matrix<double, -1, -1> X;
  Eigen::Matrix<double, -1, -1> X0;
  int link_code_mu;
  int link_prior_beta;
  int link_prior_omega0;
  double hyperprior_beta;
  double hyperprior_omega0;
  int prior_code_phi;
  double hyper_phi;
 
public:
  ~model_Beta0() { }
  
  inline std::string model_name() const final { return "model_Beta0"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_Beta0(stan::io::var_context& context__,
              unsigned int random_seed__ = 0,
              std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_Beta0_namespace::model_Beta0";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 48;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 48;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 48;
      current_statement__ = 48;
      check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 49;
      validate_non_negative_index("y", "N", N);
      current_statement__ = 50;
      context__.validate_dims("data initialization","y","double",
          context__.to_vec(N));
      y = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(y, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 50;
        assign(y_flat__, nil_index_list(), context__.vals_r("y"),
          "assigning variable y_flat__");
        current_statement__ = 50;
        pos__ = 1;
        current_statement__ = 50;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 50;
          assign(y, cons_list(index_uni(sym1__), nil_index_list()),
            y_flat__[(pos__ - 1)], "assigning variable y");
          current_statement__ = 50;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 51;
      context__.validate_dims("data initialization","K","int",
          context__.to_vec());
      K = std::numeric_limits<int>::min();
      
      current_statement__ = 51;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 51;
      current_statement__ = 51;
      check_greater_or_equal(function__, "K", K, 1);
      current_statement__ = 52;
      context__.validate_dims("data initialization","K0","int",
          context__.to_vec());
      K0 = std::numeric_limits<int>::min();
      
      current_statement__ = 52;
      K0 = context__.vals_i("K0")[(1 - 1)];
      current_statement__ = 52;
      current_statement__ = 52;
      check_greater_or_equal(function__, "K0", K0, 1);
      current_statement__ = 53;
      validate_non_negative_index("X", "N", N);
      current_statement__ = 54;
      validate_non_negative_index("X", "K", K);
      current_statement__ = 55;
      context__.validate_dims("data initialization","X","double",
          context__.to_vec(N, K));
      X = Eigen::Matrix<double, -1, -1>(N, K);
      stan::math::fill(X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 55;
        assign(X_flat__, nil_index_list(), context__.vals_r("X"),
          "assigning variable X_flat__");
        current_statement__ = 55;
        pos__ = 1;
        current_statement__ = 55;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 55;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 55;
            assign(X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_flat__[(pos__ - 1)], "assigning variable X");
            current_statement__ = 55;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 56;
      validate_non_negative_index("X0", "N", N);
      current_statement__ = 57;
      validate_non_negative_index("X0", "K0", K0);
      current_statement__ = 58;
      context__.validate_dims("data initialization","X0","double",
          context__.to_vec(N, K0));
      X0 = Eigen::Matrix<double, -1, -1>(N, K0);
      stan::math::fill(X0, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X0_flat__;
        current_statement__ = 58;
        assign(X0_flat__, nil_index_list(), context__.vals_r("X0"),
          "assigning variable X0_flat__");
        current_statement__ = 58;
        pos__ = 1;
        current_statement__ = 58;
        for (int sym1__ = 1; sym1__ <= K0; ++sym1__) {
          current_statement__ = 58;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 58;
            assign(X0,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X0_flat__[(pos__ - 1)], "assigning variable X0");
            current_statement__ = 58;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 59;
      context__.validate_dims("data initialization","link_code_mu","int",
          context__.to_vec());
      link_code_mu = std::numeric_limits<int>::min();
      
      current_statement__ = 59;
      link_code_mu = context__.vals_i("link_code_mu")[(1 - 1)];
      current_statement__ = 59;
      current_statement__ = 59;
      check_greater_or_equal(function__, "link_code_mu", link_code_mu, 1);
      current_statement__ = 60;
      context__.validate_dims("data initialization","link_prior_beta","int",
          context__.to_vec());
      link_prior_beta = std::numeric_limits<int>::min();
      
      current_statement__ = 60;
      link_prior_beta = context__.vals_i("link_prior_beta")[(1 - 1)];
      current_statement__ = 60;
      current_statement__ = 60;
      check_greater_or_equal(function__, "link_prior_beta", link_prior_beta,
                             1);
      current_statement__ = 61;
      context__.validate_dims("data initialization","link_prior_omega0",
          "int",context__.to_vec());
      link_prior_omega0 = std::numeric_limits<int>::min();
      
      current_statement__ = 61;
      link_prior_omega0 = context__.vals_i("link_prior_omega0")[(1 - 1)];
      current_statement__ = 61;
      current_statement__ = 61;
      check_greater_or_equal(function__, "link_prior_omega0",
                             link_prior_omega0, 1);
      current_statement__ = 62;
      context__.validate_dims("data initialization","hyperprior_beta",
          "double",context__.to_vec());
      hyperprior_beta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 62;
      hyperprior_beta = context__.vals_r("hyperprior_beta")[(1 - 1)];
      current_statement__ = 63;
      context__.validate_dims("data initialization","hyperprior_omega0",
          "double",context__.to_vec());
      hyperprior_omega0 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 63;
      hyperprior_omega0 = context__.vals_r("hyperprior_omega0")[(1 - 1)];
      current_statement__ = 64;
      context__.validate_dims("data initialization","prior_code_phi","int",
          context__.to_vec());
      prior_code_phi = std::numeric_limits<int>::min();
      
      current_statement__ = 64;
      prior_code_phi = context__.vals_i("prior_code_phi")[(1 - 1)];
      current_statement__ = 64;
      current_statement__ = 64;
      check_greater_or_equal(function__, "prior_code_phi", prior_code_phi, 1);
      current_statement__ = 65;
      context__.validate_dims("data initialization","hyper_phi","double",
          context__.to_vec());
      hyper_phi = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 65;
      hyper_phi = context__.vals_r("hyper_phi")[(1 - 1)];
      current_statement__ = 65;
      current_statement__ = 65;
      check_greater_or_equal(function__, "hyper_phi", hyper_phi, 0);
      current_statement__ = 66;
      validate_non_negative_index("beta", "K", K);
      current_statement__ = 67;
      validate_non_negative_index("omega0", "K0", K0);
      current_statement__ = 68;
      validate_non_negative_index("mu", "N", N);
      current_statement__ = 69;
      validate_non_negative_index("a", "N", N);
      current_statement__ = 70;
      validate_non_negative_index("b", "N", N);
      current_statement__ = 71;
      validate_non_negative_index("q0", "N", N);
      current_statement__ = 72;
      validate_non_negative_index("log_lik", "N", N);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += K;
      num_params_r__ += K0;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_Beta0_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 1;
      beta = in__.vector(K);
      Eigen::Matrix<local_scalar_t__, -1, 1> omega0;
      omega0 = Eigen::Matrix<local_scalar_t__, -1, 1>(K0);
      stan::math::fill(omega0, DUMMY_VAR__);
      
      current_statement__ = 2;
      omega0 = in__.vector(K0);
      local_scalar_t__ phi;
      phi = DUMMY_VAR__;
      
      current_statement__ = 3;
      phi = in__.scalar();
      current_statement__ = 3;
      if (jacobian__) {
        current_statement__ = 3;
        phi = stan::math::lb_constrain(phi, 0, lp__);
      } else {
        current_statement__ = 3;
        phi = stan::math::lb_constrain(phi, 0);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> mu;
      mu = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(mu, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> a;
      a = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(a, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> b;
      b = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(b, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> q0;
      q0 = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(q0, DUMMY_VAR__);
      
      current_statement__ = 8;
      assign(q0, nil_index_list(), inv_logit(multiply(X0, omega0)),
        "assigning variable q0");
      current_statement__ = 16;
      if (logical_eq(link_code_mu, 1)) {
        current_statement__ = 15;
        assign(mu, nil_index_list(), inv_logit(multiply(X, beta)),
          "assigning variable mu");
      } else {
        current_statement__ = 14;
        if (logical_eq(link_code_mu, 2)) {
          current_statement__ = 13;
          assign(mu, nil_index_list(), Phi(multiply(X, beta)),
            "assigning variable mu");
        } else {
          current_statement__ = 12;
          if (logical_eq(link_code_mu, 3)) {
            current_statement__ = 11;
            assign(mu, nil_index_list(), inv_cloglog(multiply(X, beta)),
              "assigning variable mu");
          } else {
            current_statement__ = 10;
            if (logical_eq(link_code_mu, 4)) {
              current_statement__ = 9;
              assign(mu, nil_index_list(),
                stan::math::exp(minus(stan::math::exp(multiply(X, beta)))),
                "assigning variable mu");
            } 
          }
        }
      }
      current_statement__ = 20;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 17;
        assign(b, cons_list(index_uni(i), nil_index_list()),
          ((1 - mu[(i - 1)]) * phi), "assigning variable b");
        current_statement__ = 18;
        assign(a, cons_list(index_uni(i), nil_index_list()),
          (mu[(i - 1)] * phi), "assigning variable a");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 4;
        current_statement__ = 4;
        check_greater_or_equal(function__, "mu[sym1__]", mu[(sym1__ - 1)], 0);
      }
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 4;
        current_statement__ = 4;
        check_less_or_equal(function__, "mu[sym1__]", mu[(sym1__ - 1)], 1);}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 5;
        current_statement__ = 5;
        check_greater_or_equal(function__, "a[sym1__]", a[(sym1__ - 1)], 0);}
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 6;
        current_statement__ = 6;
        check_greater_or_equal(function__, "b[sym1__]", b[(sym1__ - 1)], 0);}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 7;
        current_statement__ = 7;
        check_greater_or_equal(function__, "q0[sym1__]", q0[(sym1__ - 1)], 0);
      }
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 7;
        current_statement__ = 7;
        check_less_or_equal(function__, "q0[sym1__]", q0[(sym1__ - 1)], 1);}
      {
        current_statement__ = 30;
        if (logical_eq(prior_code_phi, 1)) {
          current_statement__ = 29;
          lp_accum__.add(gamma_lpdf<propto__>(phi, hyper_phi, hyper_phi));
        } else {
          current_statement__ = 28;
          if (logical_eq(prior_code_phi, 2)) {
            current_statement__ = 27;
            lp_accum__.add(uniform_lpdf<propto__>(phi, 0.0, hyper_phi));
          } 
        }
        current_statement__ = 36;
        for (int l = 1; l <= K; ++l) {
          current_statement__ = 34;
          if (logical_eq(link_prior_beta, 1)) {
            current_statement__ = 33;
            lp_accum__.add(
              normal_lpdf<propto__>(beta[(l - 1)], 0, hyperprior_beta));
          } else {
            current_statement__ = 32;
            if (logical_eq(link_prior_beta, 2)) {
              current_statement__ = 31;
              lp_accum__.add(
                cauchy_lpdf<propto__>(beta[(l - 1)], 0, hyperprior_beta));
            } 
          }}
        current_statement__ = 42;
        for (int l = 1; l <= K0; ++l) {
          current_statement__ = 40;
          if (logical_eq(link_prior_omega0, 1)) {
            current_statement__ = 39;
            lp_accum__.add(
              normal_lpdf<propto__>(omega0[(l - 1)], 0, hyperprior_omega0));
          } else {
            current_statement__ = 38;
            if (logical_eq(link_prior_omega0, 2)) {
              current_statement__ = 37;
              lp_accum__.add(
                cauchy_lpdf<propto__>(omega0[(l - 1)], 0, hyperprior_omega0));
            } 
          }}
        current_statement__ = 47;
        for (int i = 1; i <= N; ++i) {
          current_statement__ = 45;
          if (logical_eq(y[(i - 1)], 0)) {
            current_statement__ = 44;
            lp_accum__.add(stan::math::log(q0[(i - 1)]));
          } else {
            current_statement__ = 43;
            lp_accum__.add(
              (log1m(q0[(i - 1)]) +
                beta_lpdf<false>(y[(i - 1)], a[(i - 1)], b[(i - 1)])));
          }}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_Beta0_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      beta = in__.vector(K);
      Eigen::Matrix<double, -1, 1> omega0;
      omega0 = Eigen::Matrix<double, -1, 1>(K0);
      stan::math::fill(omega0, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      omega0 = in__.vector(K0);
      double phi;
      phi = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      phi = in__.scalar();
      current_statement__ = 3;
      phi = stan::math::lb_constrain(phi, 0);
      Eigen::Matrix<double, -1, 1> mu;
      mu = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> a;
      a = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(a, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> b;
      b = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(b, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> q0;
      q0 = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(q0, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K0; ++sym1__) {
        vars__.emplace_back(omega0[(sym1__ - 1)]);}
      vars__.emplace_back(phi);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 8;
      assign(q0, nil_index_list(), inv_logit(multiply(X0, omega0)),
        "assigning variable q0");
      current_statement__ = 16;
      if (logical_eq(link_code_mu, 1)) {
        current_statement__ = 15;
        assign(mu, nil_index_list(), inv_logit(multiply(X, beta)),
          "assigning variable mu");
      } else {
        current_statement__ = 14;
        if (logical_eq(link_code_mu, 2)) {
          current_statement__ = 13;
          assign(mu, nil_index_list(), Phi(multiply(X, beta)),
            "assigning variable mu");
        } else {
          current_statement__ = 12;
          if (logical_eq(link_code_mu, 3)) {
            current_statement__ = 11;
            assign(mu, nil_index_list(), inv_cloglog(multiply(X, beta)),
              "assigning variable mu");
          } else {
            current_statement__ = 10;
            if (logical_eq(link_code_mu, 4)) {
              current_statement__ = 9;
              assign(mu, nil_index_list(),
                stan::math::exp(minus(stan::math::exp(multiply(X, beta)))),
                "assigning variable mu");
            } 
          }
        }
      }
      current_statement__ = 20;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 17;
        assign(b, cons_list(index_uni(i), nil_index_list()),
          ((1 - mu[(i - 1)]) * phi), "assigning variable b");
        current_statement__ = 18;
        assign(a, cons_list(index_uni(i), nil_index_list()),
          (mu[(i - 1)] * phi), "assigning variable a");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 4;
        current_statement__ = 4;
        check_greater_or_equal(function__, "mu[sym1__]", mu[(sym1__ - 1)], 0);
      }
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 4;
        current_statement__ = 4;
        check_less_or_equal(function__, "mu[sym1__]", mu[(sym1__ - 1)], 1);}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 5;
        current_statement__ = 5;
        check_greater_or_equal(function__, "a[sym1__]", a[(sym1__ - 1)], 0);}
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 6;
        current_statement__ = 6;
        check_greater_or_equal(function__, "b[sym1__]", b[(sym1__ - 1)], 0);}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 7;
        current_statement__ = 7;
        check_greater_or_equal(function__, "q0[sym1__]", q0[(sym1__ - 1)], 0);
      }
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 7;
        current_statement__ = 7;
        check_less_or_equal(function__, "q0[sym1__]", q0[(sym1__ - 1)], 1);}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(mu[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(a[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(b[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(q0[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, 1> log_lik;
      log_lik = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(log_lik, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 26;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 24;
        if (logical_eq(y[(i - 1)], 0)) {
          current_statement__ = 23;
          assign(log_lik, cons_list(index_uni(i), nil_index_list()),
            stan::math::log(q0[(i - 1)]), "assigning variable log_lik");
        } else {
          current_statement__ = 22;
          assign(log_lik, cons_list(index_uni(i), nil_index_list()),
            (log1m(q0[(i - 1)]) +
              beta_lpdf<false>(y[(i - 1)], a[(i - 1)], b[(i - 1)])),
            "assigning variable log_lik");
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 1;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 1;
          assign(beta, cons_list(index_uni(sym1__), nil_index_list()),
            beta_flat__[(pos__ - 1)], "assigning variable beta");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> omega0;
      omega0 = Eigen::Matrix<double, -1, 1>(K0);
      stan::math::fill(omega0, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> omega0_flat__;
        current_statement__ = 2;
        assign(omega0_flat__, nil_index_list(), context__.vals_r("omega0"),
          "assigning variable omega0_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= K0; ++sym1__) {
          current_statement__ = 2;
          assign(omega0, cons_list(index_uni(sym1__), nil_index_list()),
            omega0_flat__[(pos__ - 1)], "assigning variable omega0");
          current_statement__ = 2;
          pos__ = (pos__ + 1);}
      }
      double phi;
      phi = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      phi = context__.vals_r("phi")[(1 - 1)];
      double phi_free__;
      phi_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      phi_free__ = stan::math::lb_free(phi, 0);
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K0; ++sym1__) {
        vars__.emplace_back(omega0[(sym1__ - 1)]);}
      vars__.emplace_back(phi_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("beta");
    names__.emplace_back("omega0");
    names__.emplace_back("phi");
    names__.emplace_back("mu");
    names__.emplace_back("a");
    names__.emplace_back("b");
    names__.emplace_back("q0");
    names__.emplace_back("log_lik");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K0)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K0; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "omega0" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "phi");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "a" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "b" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "q0" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K0; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "omega0" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "phi");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "a" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "b" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "q0" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"omega0\",\"type\":{\"name\":\"vector\",\"length\":" << K0 << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"a\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"q0\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"omega0\",\"type\":{\"name\":\"vector\",\"length\":" << K0 << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"a\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"q0\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_Beta0_namespace::model_Beta0;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_Beta0_namespace::profiles__;
}
#endif
#endif
