// Generated by rstantools.  Do not edit by hand.

/*
    FlexReg is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    FlexReg is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with FlexReg.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_FB01_phi_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_FB01_phi");
    reader.add_event(150, 148, "end", "model_FB01_phi");
    return reader;
}
#include <stan_meta_header.hpp>
class model_FB01_phi
  : public stan::model::model_base_crtp<model_FB01_phi> {
private:
        int N;
        vector_d y;
        int K;
        int K1;
        int K0;
        int H;
        matrix_d X;
        matrix_d X1;
        matrix_d X0;
        matrix_d Z;
        int link_code_mu;
        int link_prior_beta;
        int link_prior_omega1;
        int link_prior_omega0;
        double hyperprior_beta;
        double hyperprior_omega1;
        double hyperprior_omega0;
        int link_code_phi;
        int link_prior_psi;
        double hyperprior_psi;
public:
    model_FB01_phi(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_FB01_phi(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_FB01_phi_namespace::model_FB01_phi";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 3;
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(N));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            check_greater_or_equal(function__, "K", K, 1);
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "K1", "int", context__.to_vec());
            K1 = int(0);
            vals_i__ = context__.vals_i("K1");
            pos__ = 0;
            K1 = vals_i__[pos__++];
            check_greater_or_equal(function__, "K1", K1, 1);
            current_statement_begin__ = 6;
            context__.validate_dims("data initialization", "K0", "int", context__.to_vec());
            K0 = int(0);
            vals_i__ = context__.vals_i("K0");
            pos__ = 0;
            K0 = vals_i__[pos__++];
            check_greater_or_equal(function__, "K0", K0, 1);
            current_statement_begin__ = 7;
            context__.validate_dims("data initialization", "H", "int", context__.to_vec());
            H = int(0);
            vals_i__ = context__.vals_i("H");
            pos__ = 0;
            H = vals_i__[pos__++];
            check_greater_or_equal(function__, "H", H, 1);
            current_statement_begin__ = 8;
            validate_non_negative_index("X", "N", N);
            validate_non_negative_index("X", "K", K);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(N,K));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, K);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = K;
            size_t X_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 9;
            validate_non_negative_index("X1", "N", N);
            validate_non_negative_index("X1", "K1", K1);
            context__.validate_dims("data initialization", "X1", "matrix_d", context__.to_vec(N,K1));
            X1 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, K1);
            vals_r__ = context__.vals_r("X1");
            pos__ = 0;
            size_t X1_j_2_max__ = K1;
            size_t X1_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < X1_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X1_j_1_max__; ++j_1__) {
                    X1(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 10;
            validate_non_negative_index("X0", "N", N);
            validate_non_negative_index("X0", "K0", K0);
            context__.validate_dims("data initialization", "X0", "matrix_d", context__.to_vec(N,K0));
            X0 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, K0);
            vals_r__ = context__.vals_r("X0");
            pos__ = 0;
            size_t X0_j_2_max__ = K0;
            size_t X0_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < X0_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X0_j_1_max__; ++j_1__) {
                    X0(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 11;
            validate_non_negative_index("Z", "N", N);
            validate_non_negative_index("Z", "H", H);
            context__.validate_dims("data initialization", "Z", "matrix_d", context__.to_vec(N,H));
            Z = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, H);
            vals_r__ = context__.vals_r("Z");
            pos__ = 0;
            size_t Z_j_2_max__ = H;
            size_t Z_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < Z_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Z_j_1_max__; ++j_1__) {
                    Z(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "link_code_mu", "int", context__.to_vec());
            link_code_mu = int(0);
            vals_i__ = context__.vals_i("link_code_mu");
            pos__ = 0;
            link_code_mu = vals_i__[pos__++];
            check_greater_or_equal(function__, "link_code_mu", link_code_mu, 1);
            current_statement_begin__ = 13;
            context__.validate_dims("data initialization", "link_prior_beta", "int", context__.to_vec());
            link_prior_beta = int(0);
            vals_i__ = context__.vals_i("link_prior_beta");
            pos__ = 0;
            link_prior_beta = vals_i__[pos__++];
            check_greater_or_equal(function__, "link_prior_beta", link_prior_beta, 1);
            current_statement_begin__ = 14;
            context__.validate_dims("data initialization", "link_prior_omega1", "int", context__.to_vec());
            link_prior_omega1 = int(0);
            vals_i__ = context__.vals_i("link_prior_omega1");
            pos__ = 0;
            link_prior_omega1 = vals_i__[pos__++];
            check_greater_or_equal(function__, "link_prior_omega1", link_prior_omega1, 1);
            current_statement_begin__ = 15;
            context__.validate_dims("data initialization", "link_prior_omega0", "int", context__.to_vec());
            link_prior_omega0 = int(0);
            vals_i__ = context__.vals_i("link_prior_omega0");
            pos__ = 0;
            link_prior_omega0 = vals_i__[pos__++];
            check_greater_or_equal(function__, "link_prior_omega0", link_prior_omega0, 1);
            current_statement_begin__ = 16;
            context__.validate_dims("data initialization", "hyperprior_beta", "double", context__.to_vec());
            hyperprior_beta = double(0);
            vals_r__ = context__.vals_r("hyperprior_beta");
            pos__ = 0;
            hyperprior_beta = vals_r__[pos__++];
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "hyperprior_omega1", "double", context__.to_vec());
            hyperprior_omega1 = double(0);
            vals_r__ = context__.vals_r("hyperprior_omega1");
            pos__ = 0;
            hyperprior_omega1 = vals_r__[pos__++];
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "hyperprior_omega0", "double", context__.to_vec());
            hyperprior_omega0 = double(0);
            vals_r__ = context__.vals_r("hyperprior_omega0");
            pos__ = 0;
            hyperprior_omega0 = vals_r__[pos__++];
            current_statement_begin__ = 19;
            context__.validate_dims("data initialization", "link_code_phi", "int", context__.to_vec());
            link_code_phi = int(0);
            vals_i__ = context__.vals_i("link_code_phi");
            pos__ = 0;
            link_code_phi = vals_i__[pos__++];
            check_greater_or_equal(function__, "link_code_phi", link_code_phi, 2);
            current_statement_begin__ = 20;
            context__.validate_dims("data initialization", "link_prior_psi", "int", context__.to_vec());
            link_prior_psi = int(0);
            vals_i__ = context__.vals_i("link_prior_psi");
            pos__ = 0;
            link_prior_psi = vals_i__[pos__++];
            check_greater_or_equal(function__, "link_prior_psi", link_prior_psi, 1);
            current_statement_begin__ = 21;
            context__.validate_dims("data initialization", "hyperprior_psi", "double", context__.to_vec());
            hyperprior_psi = double(0);
            vals_r__ = context__.vals_r("hyperprior_psi");
            pos__ = 0;
            hyperprior_psi = vals_r__[pos__++];
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 25;
            validate_non_negative_index("beta", "K", K);
            num_params_r__ += K;
            current_statement_begin__ = 26;
            validate_non_negative_index("omega1", "K1", K1);
            num_params_r__ += K1;
            current_statement_begin__ = 27;
            validate_non_negative_index("omega0", "K0", K0);
            num_params_r__ += K0;
            current_statement_begin__ = 28;
            validate_non_negative_index("psi", "H", H);
            num_params_r__ += H;
            current_statement_begin__ = 29;
            num_params_r__ += 1;
            current_statement_begin__ = 30;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_FB01_phi() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 25;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "K", K);
        context__.validate_dims("parameter initialization", "beta", "vector_d", context__.to_vec(K));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta(K);
        size_t beta_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 26;
        if (!(context__.contains_r("omega1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable omega1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("omega1");
        pos__ = 0U;
        validate_non_negative_index("omega1", "K1", K1);
        context__.validate_dims("parameter initialization", "omega1", "vector_d", context__.to_vec(K1));
        Eigen::Matrix<double, Eigen::Dynamic, 1> omega1(K1);
        size_t omega1_j_1_max__ = K1;
        for (size_t j_1__ = 0; j_1__ < omega1_j_1_max__; ++j_1__) {
            omega1(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(omega1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable omega1: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 27;
        if (!(context__.contains_r("omega0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable omega0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("omega0");
        pos__ = 0U;
        validate_non_negative_index("omega0", "K0", K0);
        context__.validate_dims("parameter initialization", "omega0", "vector_d", context__.to_vec(K0));
        Eigen::Matrix<double, Eigen::Dynamic, 1> omega0(K0);
        size_t omega0_j_1_max__ = K0;
        for (size_t j_1__ = 0; j_1__ < omega0_j_1_max__; ++j_1__) {
            omega0(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(omega0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable omega0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 28;
        if (!(context__.contains_r("psi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable psi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("psi");
        pos__ = 0U;
        validate_non_negative_index("psi", "H", H);
        context__.validate_dims("parameter initialization", "psi", "vector_d", context__.to_vec(H));
        Eigen::Matrix<double, Eigen::Dynamic, 1> psi(H);
        size_t psi_j_1_max__ = H;
        for (size_t j_1__ = 0; j_1__ < psi_j_1_max__; ++j_1__) {
            psi(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(psi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable psi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 29;
        if (!(context__.contains_r("w")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable w missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("w");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "w", "double", context__.to_vec());
        double w(0);
        w = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, w);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable w: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 30;
        if (!(context__.contains_r("p")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable p missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("p");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "p", "double", context__.to_vec());
        double p(0);
        p = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, p);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable p: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 25;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.vector_constrain(K, lp__);
            else
                beta = in__.vector_constrain(K);
            current_statement_begin__ = 26;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> omega1;
            (void) omega1;  // dummy to suppress unused var warning
            if (jacobian__)
                omega1 = in__.vector_constrain(K1, lp__);
            else
                omega1 = in__.vector_constrain(K1);
            current_statement_begin__ = 27;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> omega0;
            (void) omega0;  // dummy to suppress unused var warning
            if (jacobian__)
                omega0 = in__.vector_constrain(K0, lp__);
            else
                omega0 = in__.vector_constrain(K0);
            current_statement_begin__ = 28;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> psi;
            (void) psi;  // dummy to suppress unused var warning
            if (jacobian__)
                psi = in__.vector_constrain(H, lp__);
            else
                psi = in__.vector_constrain(H);
            current_statement_begin__ = 29;
            local_scalar_t__ w;
            (void) w;  // dummy to suppress unused var warning
            if (jacobian__)
                w = in__.scalar_lub_constrain(0, 1, lp__);
            else
                w = in__.scalar_lub_constrain(0, 1);
            current_statement_begin__ = 30;
            local_scalar_t__ p;
            (void) p;  // dummy to suppress unused var warning
            if (jacobian__)
                p = in__.scalar_lub_constrain(0, 1, lp__);
            else
                p = in__.scalar_lub_constrain(0, 1);
            // transformed parameters
            current_statement_begin__ = 35;
            validate_non_negative_index("mu", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(N);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 36;
            validate_non_negative_index("phi", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> phi(N);
            stan::math::initialize(phi, DUMMY_VAR__);
            stan::math::fill(phi, DUMMY_VAR__);
            current_statement_begin__ = 37;
            validate_non_negative_index("lambda1", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda1(N);
            stan::math::initialize(lambda1, DUMMY_VAR__);
            stan::math::fill(lambda1, DUMMY_VAR__);
            current_statement_begin__ = 38;
            validate_non_negative_index("lambda2", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda2(N);
            stan::math::initialize(lambda2, DUMMY_VAR__);
            stan::math::fill(lambda2, DUMMY_VAR__);
            current_statement_begin__ = 39;
            validate_non_negative_index("b1", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> b1(N);
            stan::math::initialize(b1, DUMMY_VAR__);
            stan::math::fill(b1, DUMMY_VAR__);
            current_statement_begin__ = 40;
            validate_non_negative_index("b2", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> b2(N);
            stan::math::initialize(b2, DUMMY_VAR__);
            stan::math::fill(b2, DUMMY_VAR__);
            current_statement_begin__ = 41;
            validate_non_negative_index("a1", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> a1(N);
            stan::math::initialize(a1, DUMMY_VAR__);
            stan::math::fill(a1, DUMMY_VAR__);
            current_statement_begin__ = 42;
            validate_non_negative_index("a2", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> a2(N);
            stan::math::initialize(a2, DUMMY_VAR__);
            stan::math::fill(a2, DUMMY_VAR__);
            current_statement_begin__ = 43;
            validate_non_negative_index("reg1", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> reg1(N);
            stan::math::initialize(reg1, DUMMY_VAR__);
            stan::math::fill(reg1, DUMMY_VAR__);
            current_statement_begin__ = 44;
            validate_non_negative_index("reg0", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> reg0(N);
            stan::math::initialize(reg0, DUMMY_VAR__);
            stan::math::fill(reg0, DUMMY_VAR__);
            current_statement_begin__ = 45;
            validate_non_negative_index("wtilde", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> wtilde(N);
            stan::math::initialize(wtilde, DUMMY_VAR__);
            stan::math::fill(wtilde, DUMMY_VAR__);
            current_statement_begin__ = 46;
            validate_non_negative_index("q1", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> q1(N);
            stan::math::initialize(q1, DUMMY_VAR__);
            stan::math::fill(q1, DUMMY_VAR__);
            current_statement_begin__ = 47;
            validate_non_negative_index("q0", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> q0(N);
            stan::math::initialize(q0, DUMMY_VAR__);
            stan::math::fill(q0, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 49;
            stan::math::assign(reg1, stan::math::exp(multiply(X1, omega1)));
            current_statement_begin__ = 50;
            stan::math::assign(reg0, stan::math::exp(multiply(X0, omega0)));
            current_statement_begin__ = 51;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 52;
                stan::model::assign(q1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(reg1, i, "reg1", 1) / ((1 + get_base1(reg1, i, "reg1", 1)) + get_base1(reg0, i, "reg0", 1))), 
                            "assigning variable q1");
                current_statement_begin__ = 53;
                stan::model::assign(q0, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(reg0, i, "reg0", 1) / ((1 + get_base1(reg1, i, "reg1", 1)) + get_base1(reg0, i, "reg0", 1))), 
                            "assigning variable q0");
            }
            current_statement_begin__ = 55;
            if (as_bool(logical_eq(link_code_mu, 1))) {
                current_statement_begin__ = 56;
                stan::math::assign(mu, inv_logit(multiply(X, beta)));
            } else if (as_bool(logical_eq(link_code_mu, 2))) {
                current_statement_begin__ = 58;
                stan::math::assign(mu, Phi(multiply(X, beta)));
            } else if (as_bool(logical_eq(link_code_mu, 3))) {
                current_statement_begin__ = 60;
                stan::math::assign(mu, inv_cloglog(multiply(X, beta)));
            } else if (as_bool(logical_eq(link_code_mu, 4))) {
                current_statement_begin__ = 62;
                stan::math::assign(mu, stan::math::exp(minus(stan::math::exp(multiply(X, beta)))));
            }
            current_statement_begin__ = 64;
            if (as_bool(logical_eq(link_code_phi, 2))) {
                current_statement_begin__ = 65;
                stan::math::assign(phi, stan::math::exp(multiply(Z, psi)));
            } else if (as_bool(logical_eq(link_code_phi, 3))) {
                current_statement_begin__ = 67;
                stan::math::assign(phi, square(multiply(Z, psi)));
            }
            current_statement_begin__ = 69;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 70;
                stan::model::assign(wtilde, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (w * stan::math::fmin((get_base1(mu, i, "mu", 1) / p), ((1 - get_base1(mu, i, "mu", 1)) / (1 - p)))), 
                            "assigning variable wtilde");
                current_statement_begin__ = 71;
                stan::model::assign(lambda1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mu, i, "mu", 1) + ((1 - p) * get_base1(wtilde, i, "wtilde", 1))), 
                            "assigning variable lambda1");
                current_statement_begin__ = 72;
                stan::model::assign(lambda2, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mu, i, "mu", 1) - (p * get_base1(wtilde, i, "wtilde", 1))), 
                            "assigning variable lambda2");
                current_statement_begin__ = 74;
                stan::model::assign(b2, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((1 - get_base1(lambda1, i, "lambda1", 1)) * get_base1(phi, i, "phi", 1)), 
                            "assigning variable b2");
                current_statement_begin__ = 75;
                stan::model::assign(a2, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(lambda1, i, "lambda1", 1) * get_base1(phi, i, "phi", 1)), 
                            "assigning variable a2");
                current_statement_begin__ = 77;
                stan::model::assign(b1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((1 - get_base1(lambda2, i, "lambda2", 1)) * get_base1(phi, i, "phi", 1)), 
                            "assigning variable b1");
                current_statement_begin__ = 78;
                stan::model::assign(a1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(lambda2, i, "lambda2", 1) * get_base1(phi, i, "phi", 1)), 
                            "assigning variable a1");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 35;
            size_t mu_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(mu(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mu" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "mu", mu, 0);
            check_less_or_equal(function__, "mu", mu, 1);
            current_statement_begin__ = 36;
            size_t phi_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(phi(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: phi" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable phi: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "phi", phi, 0);
            current_statement_begin__ = 37;
            size_t lambda1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < lambda1_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(lambda1(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambda1" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda1: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "lambda1", lambda1, 0);
            check_less_or_equal(function__, "lambda1", lambda1, 1);
            current_statement_begin__ = 38;
            size_t lambda2_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < lambda2_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(lambda2(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: lambda2" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda2: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "lambda2", lambda2, 0);
            check_less_or_equal(function__, "lambda2", lambda2, 1);
            current_statement_begin__ = 39;
            size_t b1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < b1_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(b1(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: b1" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable b1: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "b1", b1, 0);
            current_statement_begin__ = 40;
            size_t b2_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < b2_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(b2(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: b2" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable b2: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "b2", b2, 0);
            current_statement_begin__ = 41;
            size_t a1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < a1_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(a1(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: a1" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable a1: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "a1", a1, 0);
            current_statement_begin__ = 42;
            size_t a2_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < a2_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(a2(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: a2" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable a2: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "a2", a2, 0);
            current_statement_begin__ = 43;
            size_t reg1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < reg1_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(reg1(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: reg1" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable reg1: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "reg1", reg1, 0);
            current_statement_begin__ = 44;
            size_t reg0_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < reg0_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(reg0(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: reg0" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable reg0: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "reg0", reg0, 0);
            current_statement_begin__ = 45;
            size_t wtilde_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < wtilde_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(wtilde(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: wtilde" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable wtilde: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "wtilde", wtilde, 0);
            current_statement_begin__ = 46;
            size_t q1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < q1_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(q1(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: q1" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable q1: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "q1", q1, 0);
            check_less_or_equal(function__, "q1", q1, 1);
            current_statement_begin__ = 47;
            size_t q0_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < q0_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(q0(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: q0" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable q0: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "q0", q0, 0);
            check_less_or_equal(function__, "q0", q0, 1);
            // model body
            current_statement_begin__ = 85;
            for (int l = 1; l <= K; ++l) {
                current_statement_begin__ = 86;
                if (as_bool(logical_eq(link_prior_beta, 1))) {
                    current_statement_begin__ = 87;
                    lp_accum__.add(normal_log<propto__>(get_base1(beta, l, "beta", 1), 0, hyperprior_beta));
                } else if (as_bool(logical_eq(link_prior_beta, 2))) {
                    current_statement_begin__ = 89;
                    lp_accum__.add(cauchy_log<propto__>(get_base1(beta, l, "beta", 1), 0, hyperprior_beta));
                }
            }
            current_statement_begin__ = 92;
            for (int l = 1; l <= K1; ++l) {
                current_statement_begin__ = 93;
                if (as_bool(logical_eq(link_prior_omega1, 1))) {
                    current_statement_begin__ = 94;
                    lp_accum__.add(normal_log<propto__>(get_base1(omega1, l, "omega1", 1), 0, hyperprior_omega1));
                } else if (as_bool(logical_eq(link_prior_omega1, 2))) {
                    current_statement_begin__ = 96;
                    lp_accum__.add(cauchy_log<propto__>(get_base1(omega1, l, "omega1", 1), 0, hyperprior_omega1));
                }
            }
            current_statement_begin__ = 98;
            for (int l = 1; l <= K0; ++l) {
                current_statement_begin__ = 99;
                if (as_bool(logical_eq(link_prior_omega0, 1))) {
                    current_statement_begin__ = 100;
                    lp_accum__.add(normal_log<propto__>(get_base1(omega0, l, "omega0", 1), 0, hyperprior_omega0));
                } else if (as_bool(logical_eq(link_prior_omega0, 2))) {
                    current_statement_begin__ = 102;
                    lp_accum__.add(cauchy_log<propto__>(get_base1(omega0, l, "omega0", 1), 0, hyperprior_omega0));
                }
            }
            current_statement_begin__ = 105;
            for (int l = 1; l <= H; ++l) {
                current_statement_begin__ = 106;
                if (as_bool(logical_eq(link_prior_psi, 1))) {
                    current_statement_begin__ = 107;
                    lp_accum__.add(normal_log<propto__>(get_base1(psi, l, "psi", 1), 0, hyperprior_psi));
                } else if (as_bool(logical_eq(link_prior_psi, 2))) {
                    current_statement_begin__ = 109;
                    lp_accum__.add(cauchy_log<propto__>(get_base1(psi, l, "psi", 1), 0, hyperprior_psi));
                }
            }
            current_statement_begin__ = 114;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 115;
                if (as_bool(logical_eq(get_base1(y, i, "y", 1), 1))) {
                    current_statement_begin__ = 117;
                    lp_accum__.add(stan::math::log(get_base1(q1, i, "q1", 1)));
                } else {
                    current_statement_begin__ = 120;
                    if (as_bool(logical_eq(get_base1(y, i, "y", 1), 0))) {
                        current_statement_begin__ = 122;
                        lp_accum__.add(stan::math::log(get_base1(q0, i, "q0", 1)));
                    } else {
                        current_statement_begin__ = 125;
                        lp_accum__.add((stan::math::log(((1 - get_base1(q0, i, "q0", 1)) - get_base1(q1, i, "q1", 1))) + log_mix(p, beta_log(get_base1(y, i, "y", 1), get_base1(a2, i, "a2", 1), get_base1(b2, i, "b2", 1)), beta_log(get_base1(y, i, "y", 1), get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1)))));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta");
        names__.push_back("omega1");
        names__.push_back("omega0");
        names__.push_back("psi");
        names__.push_back("w");
        names__.push_back("p");
        names__.push_back("mu");
        names__.push_back("phi");
        names__.push_back("lambda1");
        names__.push_back("lambda2");
        names__.push_back("b1");
        names__.push_back("b2");
        names__.push_back("a1");
        names__.push_back("a2");
        names__.push_back("reg1");
        names__.push_back("reg0");
        names__.push_back("wtilde");
        names__.push_back("q1");
        names__.push_back("q0");
        names__.push_back("log_lik");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K1);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(H);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_FB01_phi_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta = in__.vector_constrain(K);
        size_t beta_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            vars__.push_back(beta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> omega1 = in__.vector_constrain(K1);
        size_t omega1_j_1_max__ = K1;
        for (size_t j_1__ = 0; j_1__ < omega1_j_1_max__; ++j_1__) {
            vars__.push_back(omega1(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> omega0 = in__.vector_constrain(K0);
        size_t omega0_j_1_max__ = K0;
        for (size_t j_1__ = 0; j_1__ < omega0_j_1_max__; ++j_1__) {
            vars__.push_back(omega0(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> psi = in__.vector_constrain(H);
        size_t psi_j_1_max__ = H;
        for (size_t j_1__ = 0; j_1__ < psi_j_1_max__; ++j_1__) {
            vars__.push_back(psi(j_1__));
        }
        double w = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(w);
        double p = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(p);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 35;
            validate_non_negative_index("mu", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> mu(N);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 36;
            validate_non_negative_index("phi", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> phi(N);
            stan::math::initialize(phi, DUMMY_VAR__);
            stan::math::fill(phi, DUMMY_VAR__);
            current_statement_begin__ = 37;
            validate_non_negative_index("lambda1", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> lambda1(N);
            stan::math::initialize(lambda1, DUMMY_VAR__);
            stan::math::fill(lambda1, DUMMY_VAR__);
            current_statement_begin__ = 38;
            validate_non_negative_index("lambda2", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> lambda2(N);
            stan::math::initialize(lambda2, DUMMY_VAR__);
            stan::math::fill(lambda2, DUMMY_VAR__);
            current_statement_begin__ = 39;
            validate_non_negative_index("b1", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> b1(N);
            stan::math::initialize(b1, DUMMY_VAR__);
            stan::math::fill(b1, DUMMY_VAR__);
            current_statement_begin__ = 40;
            validate_non_negative_index("b2", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> b2(N);
            stan::math::initialize(b2, DUMMY_VAR__);
            stan::math::fill(b2, DUMMY_VAR__);
            current_statement_begin__ = 41;
            validate_non_negative_index("a1", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> a1(N);
            stan::math::initialize(a1, DUMMY_VAR__);
            stan::math::fill(a1, DUMMY_VAR__);
            current_statement_begin__ = 42;
            validate_non_negative_index("a2", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> a2(N);
            stan::math::initialize(a2, DUMMY_VAR__);
            stan::math::fill(a2, DUMMY_VAR__);
            current_statement_begin__ = 43;
            validate_non_negative_index("reg1", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> reg1(N);
            stan::math::initialize(reg1, DUMMY_VAR__);
            stan::math::fill(reg1, DUMMY_VAR__);
            current_statement_begin__ = 44;
            validate_non_negative_index("reg0", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> reg0(N);
            stan::math::initialize(reg0, DUMMY_VAR__);
            stan::math::fill(reg0, DUMMY_VAR__);
            current_statement_begin__ = 45;
            validate_non_negative_index("wtilde", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> wtilde(N);
            stan::math::initialize(wtilde, DUMMY_VAR__);
            stan::math::fill(wtilde, DUMMY_VAR__);
            current_statement_begin__ = 46;
            validate_non_negative_index("q1", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> q1(N);
            stan::math::initialize(q1, DUMMY_VAR__);
            stan::math::fill(q1, DUMMY_VAR__);
            current_statement_begin__ = 47;
            validate_non_negative_index("q0", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> q0(N);
            stan::math::initialize(q0, DUMMY_VAR__);
            stan::math::fill(q0, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 49;
            stan::math::assign(reg1, stan::math::exp(multiply(X1, omega1)));
            current_statement_begin__ = 50;
            stan::math::assign(reg0, stan::math::exp(multiply(X0, omega0)));
            current_statement_begin__ = 51;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 52;
                stan::model::assign(q1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(reg1, i, "reg1", 1) / ((1 + get_base1(reg1, i, "reg1", 1)) + get_base1(reg0, i, "reg0", 1))), 
                            "assigning variable q1");
                current_statement_begin__ = 53;
                stan::model::assign(q0, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(reg0, i, "reg0", 1) / ((1 + get_base1(reg1, i, "reg1", 1)) + get_base1(reg0, i, "reg0", 1))), 
                            "assigning variable q0");
            }
            current_statement_begin__ = 55;
            if (as_bool(logical_eq(link_code_mu, 1))) {
                current_statement_begin__ = 56;
                stan::math::assign(mu, inv_logit(multiply(X, beta)));
            } else if (as_bool(logical_eq(link_code_mu, 2))) {
                current_statement_begin__ = 58;
                stan::math::assign(mu, Phi(multiply(X, beta)));
            } else if (as_bool(logical_eq(link_code_mu, 3))) {
                current_statement_begin__ = 60;
                stan::math::assign(mu, inv_cloglog(multiply(X, beta)));
            } else if (as_bool(logical_eq(link_code_mu, 4))) {
                current_statement_begin__ = 62;
                stan::math::assign(mu, stan::math::exp(minus(stan::math::exp(multiply(X, beta)))));
            }
            current_statement_begin__ = 64;
            if (as_bool(logical_eq(link_code_phi, 2))) {
                current_statement_begin__ = 65;
                stan::math::assign(phi, stan::math::exp(multiply(Z, psi)));
            } else if (as_bool(logical_eq(link_code_phi, 3))) {
                current_statement_begin__ = 67;
                stan::math::assign(phi, square(multiply(Z, psi)));
            }
            current_statement_begin__ = 69;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 70;
                stan::model::assign(wtilde, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (w * stan::math::fmin((get_base1(mu, i, "mu", 1) / p), ((1 - get_base1(mu, i, "mu", 1)) / (1 - p)))), 
                            "assigning variable wtilde");
                current_statement_begin__ = 71;
                stan::model::assign(lambda1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mu, i, "mu", 1) + ((1 - p) * get_base1(wtilde, i, "wtilde", 1))), 
                            "assigning variable lambda1");
                current_statement_begin__ = 72;
                stan::model::assign(lambda2, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(mu, i, "mu", 1) - (p * get_base1(wtilde, i, "wtilde", 1))), 
                            "assigning variable lambda2");
                current_statement_begin__ = 74;
                stan::model::assign(b2, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((1 - get_base1(lambda1, i, "lambda1", 1)) * get_base1(phi, i, "phi", 1)), 
                            "assigning variable b2");
                current_statement_begin__ = 75;
                stan::model::assign(a2, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(lambda1, i, "lambda1", 1) * get_base1(phi, i, "phi", 1)), 
                            "assigning variable a2");
                current_statement_begin__ = 77;
                stan::model::assign(b1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((1 - get_base1(lambda2, i, "lambda2", 1)) * get_base1(phi, i, "phi", 1)), 
                            "assigning variable b1");
                current_statement_begin__ = 78;
                stan::model::assign(a1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(lambda2, i, "lambda2", 1) * get_base1(phi, i, "phi", 1)), 
                            "assigning variable a1");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 35;
            check_greater_or_equal(function__, "mu", mu, 0);
            check_less_or_equal(function__, "mu", mu, 1);
            current_statement_begin__ = 36;
            check_greater_or_equal(function__, "phi", phi, 0);
            current_statement_begin__ = 37;
            check_greater_or_equal(function__, "lambda1", lambda1, 0);
            check_less_or_equal(function__, "lambda1", lambda1, 1);
            current_statement_begin__ = 38;
            check_greater_or_equal(function__, "lambda2", lambda2, 0);
            check_less_or_equal(function__, "lambda2", lambda2, 1);
            current_statement_begin__ = 39;
            check_greater_or_equal(function__, "b1", b1, 0);
            current_statement_begin__ = 40;
            check_greater_or_equal(function__, "b2", b2, 0);
            current_statement_begin__ = 41;
            check_greater_or_equal(function__, "a1", a1, 0);
            current_statement_begin__ = 42;
            check_greater_or_equal(function__, "a2", a2, 0);
            current_statement_begin__ = 43;
            check_greater_or_equal(function__, "reg1", reg1, 0);
            current_statement_begin__ = 44;
            check_greater_or_equal(function__, "reg0", reg0, 0);
            current_statement_begin__ = 45;
            check_greater_or_equal(function__, "wtilde", wtilde, 0);
            current_statement_begin__ = 46;
            check_greater_or_equal(function__, "q1", q1, 0);
            check_less_or_equal(function__, "q1", q1, 1);
            current_statement_begin__ = 47;
            check_greater_or_equal(function__, "q0", q0, 0);
            check_less_or_equal(function__, "q0", q0, 1);
            // write transformed parameters
            if (include_tparams__) {
                size_t mu_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                    vars__.push_back(mu(j_1__));
                }
                size_t phi_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                    vars__.push_back(phi(j_1__));
                }
                size_t lambda1_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < lambda1_j_1_max__; ++j_1__) {
                    vars__.push_back(lambda1(j_1__));
                }
                size_t lambda2_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < lambda2_j_1_max__; ++j_1__) {
                    vars__.push_back(lambda2(j_1__));
                }
                size_t b1_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < b1_j_1_max__; ++j_1__) {
                    vars__.push_back(b1(j_1__));
                }
                size_t b2_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < b2_j_1_max__; ++j_1__) {
                    vars__.push_back(b2(j_1__));
                }
                size_t a1_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < a1_j_1_max__; ++j_1__) {
                    vars__.push_back(a1(j_1__));
                }
                size_t a2_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < a2_j_1_max__; ++j_1__) {
                    vars__.push_back(a2(j_1__));
                }
                size_t reg1_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < reg1_j_1_max__; ++j_1__) {
                    vars__.push_back(reg1(j_1__));
                }
                size_t reg0_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < reg0_j_1_max__; ++j_1__) {
                    vars__.push_back(reg0(j_1__));
                }
                size_t wtilde_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < wtilde_j_1_max__; ++j_1__) {
                    vars__.push_back(wtilde(j_1__));
                }
                size_t q1_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < q1_j_1_max__; ++j_1__) {
                    vars__.push_back(q1(j_1__));
                }
                size_t q0_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < q0_j_1_max__; ++j_1__) {
                    vars__.push_back(q0(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 132;
            validate_non_negative_index("log_lik", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 133;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 134;
                if (as_bool(logical_eq(get_base1(y, i, "y", 1), 1))) {
                    current_statement_begin__ = 136;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                stan::math::log(get_base1(q1, i, "q1", 1)), 
                                "assigning variable log_lik");
                } else {
                    current_statement_begin__ = 139;
                    if (as_bool(logical_eq(get_base1(y, i, "y", 1), 0))) {
                        current_statement_begin__ = 141;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    stan::math::log(get_base1(q0, i, "q0", 1)), 
                                    "assigning variable log_lik");
                    } else {
                        current_statement_begin__ = 144;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (stan::math::log(((1 - get_base1(q0, i, "q0", 1)) - get_base1(q1, i, "q1", 1))) + log_mix(p, beta_log(get_base1(y, i, "y", 1), get_base1(a2, i, "a2", 1), get_base1(b2, i, "b2", 1)), beta_log(get_base1(y, i, "y", 1), get_base1(a1, i, "a1", 1), get_base1(b1, i, "b1", 1)))), 
                                    "assigning variable log_lik");
                    }
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 132;
            size_t log_lik_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_FB01_phi";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t omega1_j_1_max__ = K1;
        for (size_t j_1__ = 0; j_1__ < omega1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "omega1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t omega0_j_1_max__ = K0;
        for (size_t j_1__ = 0; j_1__ < omega0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "omega0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t psi_j_1_max__ = H;
        for (size_t j_1__ = 0; j_1__ < psi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "w";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t mu_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t phi_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t lambda1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < lambda1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t lambda2_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < lambda2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < b1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b2_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < b2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t a1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < a1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t a2_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < a2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t reg1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < reg1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "reg1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t reg0_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < reg0_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "reg0" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t wtilde_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < wtilde_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "wtilde" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t q1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < q1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "q1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t q0_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < q0_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "q0" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t omega1_j_1_max__ = K1;
        for (size_t j_1__ = 0; j_1__ < omega1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "omega1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t omega0_j_1_max__ = K0;
        for (size_t j_1__ = 0; j_1__ < omega0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "omega0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t psi_j_1_max__ = H;
        for (size_t j_1__ = 0; j_1__ < psi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "w";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t mu_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t phi_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t lambda1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < lambda1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t lambda2_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < lambda2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < b1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t b2_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < b2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t a1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < a1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t a2_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < a2_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "a2" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t reg1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < reg1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "reg1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t reg0_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < reg0_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "reg0" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t wtilde_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < wtilde_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "wtilde" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t q1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < q1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "q1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t q0_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < q0_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "q0" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_FB01_phi_namespace::model_FB01_phi stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
