% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_effects.R
\name{plot_effects}
\alias{plot_effects}
\title{Graphics for plot effects}
\usage{
plot_effects(df, effect, blocks = TRUE, labels = FALSE)
}
\arguments{
\item{df}{A data frame with columns 'col', 'row', and the effect to be plotted. When \code{df}
also contains a 'block' column, the field array is split into blocks if \code{blocks = TRUE}.}

\item{effect}{The effect to be plotted.}

\item{blocks}{When \code{TRUE} (default), the field array is split into blocks.}

\item{labels}{When \code{TRUE}, row and column numbers are plotted. By default,
\code{labels = FALSE}.}
}
\value{
A graphical field array, in which the colour gradient ranges from red (low value)
to green (high value).
}
\description{
Graphically displays plot effects (e.g., phenotypes, genetic values, plot errors) onto a
field array, in which the colour gradient ranges from red (low value) to green (high value).
The function requires a data frame generated with field_trial_error as an input, or any data
frame with columns 'col', 'row', and the effect to be displayed. When the data frame contains a
'block' column, the field array is split into blocks if \code{blocks = TRUE}.
}
\examples{
# Plot the simulated plot errors for trait 2 in environment 2 provided in the example data
# frame 'df_error_bivar'.

error_df <- df_error_bivar[df_error_bivar$env == 2, ]

plot_effects(
  df = error_df,
  effect = "e.Trait.2"
)
}
